jQuery(document).ready(function($) {
    $('#preloader').hide();
    //
    setTimeout(() => {
        $('.alert-c').addClass('alert-c-top');
        setTimeout(() => {
            $('.alert-c').remove();
        }, 500);
    }, 1500);
	//richtext
    $('.tableRichText').richTxt();
    $('.tableRichText').each(function(e){
        var content = $(this).val();
        $(this).parent().find('.richTxt').html(content);
    });
    $(document).find('.richTxt').bind('DOMSubtreeModified', function(e){
        $(this).parent().find('.tableRichText').val($(this).html());
    });
    //
    $(document).on('click', '.card-c .btn-pencil', function(e){
        e.preventDefault();

        $('#editPos').val('left');
        $('#editTitle').val('');
        $('#editPopup').val(1);
        $('#editImage').attr('src', './img/no-photo.png');
        $('.tableRichText').val('');
        $('#richTxt1').html('');
        $('#idItem').val('');

        var parent = $(this).attr('data-parent');
        var id = $(parent).attr('data-id');

        var pos = $(parent).attr('data-position');
        var year = $(parent).find('.card-c-title').text();
        var popup = $(parent).attr('data-popup');
        var img = $(parent).find('.card-image img').attr('src');
        var txt = $(parent).find('.cardTxtHidden').html();
        $('#editPos').val(pos);
        $('#editTitle').val(year);
        $('#editPopup').val(popup);
        $('#editImage').attr('src', img);
        $('.tableRichText').val(txt);
        $('#richTxt1').html(txt);
        $('#idItem').val(id);
        $('#editModal').modal('show');
    });
    //
    $(document).on('click', '.imgPre', function(e){
        var inputFile = $(this).data('file');
        $(inputFile).click();
    });
    $(document).on('change', '.inputFileChange', function(){
        const file = this.files[0];
        var img = $(this).attr('data-img');
        if (file){
            let reader = new FileReader();
            reader.onload = function(event){
            console.log(event.target.result);
            $(img).attr('src', event.target.result);
        }
        reader.readAsDataURL(file);
        }
    });
    //
    $(document).on('click', '.btnNewBloc', function(e){
        e.preventDefault();
        $('#sidebar').addClass('active');
        $('#newModal').modal('show');
    });
    //
    $(document).on('input', '#inputRadius', function(e){
        e.preventDefault();
        var num = $(this).val();
        $('.radiusResult').text(num);
        $(document).find('.card-c').css('border-radius', num+'px');
    });
    $(document).on('change', '#inputRadius', function(e){
        e.preventDefault();
        $('#preloader').show();
        setTimeout(() => {
            $('#updateRadius').submit();
        }, 500);
    });
    //
    $( "#sortable" ).sortable({
        connectWith: "#sortable",
        handle: ".btn-move",
        cancel: ".portlet-toggle",
        update: function() {//event, ui
            $('#preloader').show();
            $('.prevPos').html('');
            updatePos();
            //console.log(ui.item.index());
        }
    });
    $( "#sortable" ).disableSelection();
    //
    $(document).on('click', '.btnOpenFront', function(e){
        e.preventDefault();
        var url = $(this).data('url');
        window.open(url);
    });
    //delete alert
    $(document).on('click', '.delete-c', function(e){
        var r = confirm("Segur que vols eliminar?");
        if (r == true) {
            return true;
        } else {
            return false;
        }
    });
    //
    function updatePos()
    {
        $(document).find('.card-c').each(function(e){
            var id = $(this).attr('data-id');
            $('.prevPos').prepend('<input type="hidden" name="num_items[]" value="'+e+'">');
            $('.prevPos').prepend('<input type="hidden" name="id_items[]" value="'+id+'">');

            setTimeout(() => {
                $('#formPos').submit();
            }, 1000);
        });
    }
});