//$.noConflict();
(function($){  
    $.fn.richTxt = function(options) {

    	// Default options
        var settings = $.extend({
            height: 260,
            color: '#1a9bfc',
            bold: true,
            italic: true,
            underline: true,
            list: true
        }, options );
        var num = 1;

	    this.each(function(e){

            var container = `<div class="richTxt" contenteditable="true" id="richTxt`+num+`"></div>`;
            var tools = '<div class="navbarTools">';
            if(settings.bold)
                tools += `<a href="#" class="tichTxtBtn" data-type="bold" data-parent="#richTxtWrap`+num+`" data-child="#richTxt`+num+`">
                    <i class="fa fa-bold"></i>
                </a>`;
            if(settings.italic)
                tools += `<a href="#" class="tichTxtBtn" data-type="italic" data-parent="#richTxtWrap`+num+`" data-child="#richTxt`+num+`">
                    <i class="fa fa-italic"></i>
                </a>`;
            if(settings.underline)
                tools += `<a href="#" class="tichTxtBtn" data-type="underline" data-parent="#richTxtWrap`+num+`" data-child="#richTxt`+num+`">
                    <i class="fa fa-underline"></i>
                </a>`;
            if(settings.list)
                tools += `<a href="#" class="tichTxtBtn" data-type="list" data-parent="#richTxtWrap`+num+`" data-child="#richTxt`+num+`">
                    <i class="fa fa-list"></i>
                </a>`;
            tools += '</div>';

            $(this).wrap('<div class="richTxtWrap" id="richTxtWrap'+num+'">');
            $(this).parent().prepend(container);
            $(this).parent().prepend(tools);
            num++;

	    });

        $(document).on('focus', '.richTxt', function(e){
            e.preventDefault();
            e.stopPropagation();
            $(this).addClass('richTxtActive');
        });
        $(document).on('focusout', '.richTxt', function(e){
            e.preventDefault();
            e.stopPropagation();
            $(this).removeClass('richTxtActive');
        });

        $(document).on('click', '.tichTxtBtn', function(e){
            e.preventDefault();
            e.stopPropagation();
            var child = $(this).data('child');
            var type = $(this).data('type');
            if(type == 'bold')
                document.execCommand('bold', false, null);
            if(type == 'italic')
                document.execCommand('italic', false, null);
            if(type == 'underline')
                document.execCommand('underline', false, null);
            if(type == 'list')
                document.execCommand('insertUnorderedList', false, null);
        });

        $(document).find('.richTxt').css({
            'height':settings.height+'px',
        });
        $(document).find('.tichTxtBtn').css({
            'color':settings.color,
        });

    };

})(jQuery);