<?php

include './conn.php';
$conn = OpenCon();

$message = NULL;
session_start();
if(isset($_SESSION['flash_message'])) {
    $message = $_SESSION['flash_message'];
    unset($_SESSION['flash_message']);
}

$items = NULL;
$settings = NULL;
if($conn){
    $sql = "SELECT * FROM items WHERE status_item = 1 ORDER BY num_item";
    $items = $conn->query($sql);
    $sql2 = "SELECT * FROM settings WHERE id_setting = 1";
    $settings = $conn->query($sql2);
}

CloseCon($conn);

function cut_text($x, $length = 55)
{
    if(strlen($x) <= $length){
        return $x;
    }
    else{
        $y = substr($x, 0, $length).'...';
        return $y;
    }
}

?>

<!doctype html>
<html lang="es">
<head>
<meta charset="utf-8">
<meta name="robots" content="noindex,nofollow">
<meta name="googlebot" content="noindex,nofollow">
<meta name="viewport" content="width=device-width, initial-scale=1">
<title>25 anys de Grafix</title>
<link href="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/css/bootstrap.min.css" rel="stylesheet" integrity="sha384-4bw+/aepP/YC94hEpVNVgiZdgIC5+VKNBQNGCHeKRQN+PtmoHDEXuppvnDJzQIu9" crossorigin="anonymous">
<link href="https://maxcdn.bootstrapcdn.com/font-awesome/4.3.0/css/font-awesome.min.css" rel="stylesheet">
<?php
$cardRadius = '100px';
if($settings){
    $cardRadius = $settings->fetch_assoc()['radius_setting'];
}
?>
<style>
:root {
    --card-radius: <?= $cardRadius ?>px;
}
</style>
<link rel="stylesheet" href="./css/main.css">
<link href='https://fonts.googleapis.com/css?family=Montserrat' rel='stylesheet'>
</head>
<body style="background-image: url('https://devgrafix.com/25/img/FONS-WEB-PATTERN-25.png');">

    <div class="preWrapFixed"></div>

    <div id="wrapper">

        <div class="container-fluid p-3 container-wrapper">

            <div class="pre-wrap" style="display:none"></div>

            <div class="cards">
                <?php if($items): ?>
                <?php $i = 0; while($item = mysqli_fetch_object($items)): ?>
                <div style="border: 7px solid #283583;" id="card-item-<?= $i ?>" class="card-c card-<?= $item->pos_item ?> <?= ($i <= 0)?'card-c-active card-c-first card-c-first-active':'card-c-h' ?>" data-next="#card-item-<?= $i+1 ?>" data-popup="<?= $item->modal_item ?>">
                    <div class="card-image">
                        <?php
                        $img = './img/no-photo.png';
                        if($item->img_item)
                            $img = './uploads/'.$item->img_item;
                        ?>
                        <img src="<?= $img ?>">
                    </div>
                    <div class="card-text">
                        <h3 style="font-family: Montserrat; font-weight: bolder; color: #DF3439;"><?= $item->title_item ?></h3>  <!-- class="mb-0 fw-bold card-c-title text-dark" -->
                        <div><?= ($item->resume_item)?$item->resume_item:'...' ?></div>
                    </div>
                    <div class="cardTxtHidden" style="display:none"><?= ($item->txt_item)?$item->txt_item:'...' ?></div>
                </div>
                <?php $i++; endwhile; ?>
                <?php endif; ?>
            </div>
        </div>

    </div>

<?php require_once('popup.php'); ?>

<script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.1/dist/js/bootstrap.bundle.min.js" integrity="sha384-HwwvtgBNo3bZJJLYd8oVXjrBZt8cqVSpeBNS5n7C8IVInixGAoxmnlMuBnhbgrkm" crossorigin="anonymous"></script>
<script src="https://cdn.jsdelivr.net/npm/jquery@3.5.1/dist/jquery.slim.min.js" integrity="sha384-DfXdz2htPH0lsSSs5nCTpuj/zy4C+OGpamoFVy38MVBnE+IbbVYUew+OrCXaRkfj" crossorigin="anonymous"></script>
<script src="./js/main.js"></script>
</body>
</html>