<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Libraries\Make_bread;
use App\Models\UsersTable;
use App\Models\SeccionsModel;
use App\Models\PressupostosModel;
use App\Models\ClientsModel;

class Application extends BaseController
{
    protected  function init(){

        /*if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }*/
        $this->_created = date('Y-m-d H:i:s');
        $this->_modified = date('Y-m-d H:i:s');
    }
    /*
     * User Dashboard
     */
	public function index()
	{
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $this->init();
        // first load the library breadcrumb
        $make_bread = new Make_bread;
        $breadcrumb = $make_bread->output();
        $data=[
            'heading' =>'Panell de control',
        ];
        $data['breadcrumb'] =$breadcrumb;

        $db =  db_connect();
        $userModel = new UsersTable($db);
        $currentEmpresaId = session()->get('empresa_id_user');
        $resultUsers = $userModel->getCountUser($currentEmpresaId);
        $seccionsModel = new SeccionsModel($db);
        $resultSeccions = $seccionsModel->getCount();
        $pressupostosModel = new PressupostosModel($db);
        $resultPressupostos = $pressupostosModel->getCount($currentEmpresaId);
        $clientsModel = new ClientsModel($db);
        $resultClients = $clientsModel->getCount($currentEmpresaId);
        $data['count'] = $resultUsers;
        $data['countSeccions'] = $resultSeccions;
        $data['countPressu'] = $resultPressupostos;
        $data['countClients'] = $resultClients;
		return view('admin/app/dashboard', $data);
	}

}
