<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Libraries\Make_bread;
use App\Models\PressupostosModel;
use App\Models\ConfiguracioModel;
use App\Models\FrontModel;
use http\Url;

use App\Libraries\Pdf;

class Pressupostos extends BaseController
{

    /*
     * Pressupostos
     */
	public function index()
	{
        $session = session();
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        //$this->init();
        // first load the library breadcrumb
        $make_bread = new Make_bread;
        $data=[
            'heading' =>'Pressupostos',
        ];
        $make_bread->add('Pressupostos', 'pressupostos', TRUE);
        $breadcrumb = $make_bread->output();
        $data['breadcrumb'] =$breadcrumb;

        $db =  db_connect();
        $pressupostos = new  PressupostosModel($db);
        $currentEmpresaId = session()->get('empresa_id_user');
        $data['pressupostos'] = $pressupostos->getAll($currentEmpresaId);
        $data['num'] = $pressupostos->getCount($currentEmpresaId);
		return view('admin/app/pressupostos', $data);
	}

    public function pressupost($id)
    {
        $session = session();
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        //$this->init();
        // first load the library breadcrumb
        $make_bread = new Make_bread;
        $data=[
            'heading' =>'Pressupost',
        ];
        $make_bread->add('Pressupostos', 'pressupostos', TRUE);
        $make_bread->add('Pressupost', 'pressupost/'.$id, TRUE);
        $breadcrumb = $make_bread->output();
        $data['breadcrumb'] =$breadcrumb;

        $db =  db_connect();
        $pressupostos = new  PressupostosModel($db);
        $data['pressupost'] = $pressupostos->getPressupost($id);
		return view('admin/app/pressupost', $data);
    }

    public function resumPressupost($id)
    {
        $session = session();
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }

        if(session()->get('isLoggedIn')){
            $db =  db_connect();
            $configuracio = new  ConfiguracioModel($db);
            $currentEmpresaId = session()->get('empresa_id_user');
            $data['empresa'] = $configuracio->getEmpresa($currentEmpresaId);
        }

        $db =  db_connect();
        $pressupostos = new  PressupostosModel($db);
        $data['pressupost'] = $pressupostos->getResumPressupost($id);
		return view('pressupostResum', $data);
    }

    public function editarPressupost($idPressu)
    {
        $session = session();
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }

        $db =  db_connect();
        $configuracio = new  ConfiguracioModel($db);
        $currentEmpresaId = session()->get('empresa_id_user');
        $data['empresa'] = $configuracio->getEmpresa($currentEmpresaId);
        
        $pressupostos = new  PressupostosModel($db);
        $pressu = $pressupostos->getPressupost($idPressu);
        $data['pressupost'] = $pressupostos->getItemsPressupost($idPressu);

        /**
         * SESSION CLIENT INFO
         */
        $clientData = [
            'nomClient'  => $pressu->nom_client,
            'emailClient' => $pressu->email_client,
            'telClient' => $pressu->tel_client,
            'cifClient' => $pressu->cif_client,
            'dirClient' => $pressu->dir_client,
            'objectiusClient' => $pressu->objectius_pressupost,
            'seccioClient' => $pressu->seccio_id_pressupost,
            'codiPresu' => $pressu->num_pressupost,
            'seccioId' => $pressu->seccio_id_pressupost
        ];
        
        $session = session();
        $session->set($clientData);
        //
        $seccions = new  FrontModel($db);
        $seccionsArr = explode(',', $pressu->seccio_id_pressupost);
        $data['opcions'] = $seccions->getAllOpcionsMultiple($seccionsArr);
        $data['seccio'] = $seccions->getSeccioMultiple($seccionsArr);
        $data['seccioId'] = $pressu->seccio_id_pressupost;
        
        
        if($_POST)
        {
            
            //signatura
            $imgBase = $this->request->getPost('firma');

            if($imgBase){
            list($type, $data) = explode(';', $imgBase);
            list(, $imgBase) = explode(',', $imgBase);
            $imgBase = base64_decode($imgBase);
            $imgName = $pressu->signatura_pressupost;
            if(file_put_contents('./uploads/signatures/'.$imgName, $imgBase)){

                $signatura = $imgName;
            }else{
                $signatura = NULL;
            }
            }else{
                return NULL;
            }

            //PRESSUPOST
            $num = $pressu->num_pressupost;
            $data = date('d-m-Y');
            $preu = $this->request->getPost('preu');
            $objectius = $pressu->objectius_pressupost;
            $client = $pressu->client_id_pressupost;
            $seccioId = $this->request->getPost('seccioId');
            $resum = $this->request->getPost('resum');
            $items = $this->request->getPost('items');
            $comentaris = $this->request->getPost('comentaris');
            $boxTotal = $this->request->getPost('boxTotal');
            $pdfName = $pressu->pdf_pressupost;
            if($this->request->getPost('pagament')){
                $pagament = $this->request->getPost('pagament');
            }else{
                $pagament = NULL;
            }

            $data = [
                'empresa_id_pressupost' => $currentEmpresaId,
                'num_pressupost' => $num,
                'data_pressupost' => $data,
                'preu_pressupost' => $preu,
                'objectius_pressupost' => $objectius,
                'client_id_pressupost' => $client,
                'seccio_id_pressupost' => $seccioId,
                'resum_pressupost' => $resum,
                'items_pressupost' => $items,
                'comentaris_items_pressupost' => $comentaris,
                'estimation_pressupost' => $boxTotal,
                'signatura_pressupost' => $signatura,
                'pagament_pressupost' => $pagament,
                'pdf_pressupost' => $pdfName
            ];

            $builder = $db->table('pressupostos');
            $builder->where('id_pressupost', $idPressu);
            if($builder->update($data)){

                //PDF
                $lastPressupostId = $db->insertID();
                $db =  db_connect();
                $pressupostos = new  PressupostosModel($db);
                $data['pressupost'] = $pressupostos->getResumPressupost($pressu->id_pressupost);
                $configuracio = new ConfiguracioModel($db);
                $data['empresa'] = $configuracio->getEmpresa($pressu->empresa_id_pressupost);
                $html = view('pdfPressupost', $data);
                $pdf = new Pdf();
                $pdf->createPDF($html, $pdfName, false, 'A4', 'portrait');

                $session->setFlashdata('success', 'Pressupost actualitzat correctament');
                return  redirect()->to(base_url().'/pressupostos/resumpressupost/'.$idPressu);
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return  redirect()->to(base_url().'/pressupostos/resumpressupost/'.$idPressu);
            }

        }else{
            return view('seccio', $data);
        }
    }

}