<?php namespace App\Controllers;

use App\Controllers\BaseController;
use App\Libraries\Make_bread;
use App\Models\SeccionsModel;

class Seccions extends BaseController
{

    /*
     * Seccions
     */
	public function index()
	{
        $session = session();
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        //$this->init();
        // first load the library breadcrumb
        $make_bread = new Make_bread;
        $data=[
            'heading' =>'Seccions',
        ];
        $make_bread->add('Seccions', 'seccions', TRUE);
        $breadcrumb = $make_bread->output();
        $data['breadcrumb'] =$breadcrumb;

        $db =  db_connect();
        $seccions = new  SeccionsModel($db);
        $data['seccions'] = $seccions->getAll();
        $data['num'] = $seccions->getCount();
		return view('admin/app/seccions', $data);
	}

    /**
     * Seccions
    */
    public function seccio($id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        // first load the library breadcrumb
        $make_bread = new Make_bread;
        $data=[
            'heading' =>'Secció',
        ];
        $make_bread->add('Seccions', 'seccions', TRUE);
        $make_bread->add('Secció', 'seccio/'.$id, TRUE);
        $breadcrumb = $make_bread->output();
        $data['breadcrumb'] =$breadcrumb;
        $db =  db_connect();
        $seccions = new  SeccionsModel($db);
        $data['seccio'] = $seccions->getSeccio($id);
        $data['opcions'] = $seccions->getAllOpcions($id);
		return view('admin/app/seccio', $data);
    }

    public function nova_seccio()
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $data=[
            'heading' =>'Secció',
        ];
        $session = session();
        if($_POST)
        {
            $nom = $this->request->getPost('nom');
            $icona = $this->request->getPost('icona');
            $preu = $this->request->getPost('preu');
            $desc = $this->request->getPost('desc');
            if($this->request->getPost('pagines')){
                $pagines = $this->request->getPost('pagines');
            }else{
                $pagines = NULL;
            }
            if($this->request->getPost('comentaris')){
                $comentaris = $this->request->getPost('comentaris');
            }else{
                $comentaris = NULL;
            }
            if($this->request->getPost('manteniment')){
                $manteniment = $this->request->getPost('manteniment');
            }else{
                $manteniment = NULL;
            }
            if($this->request->getPost('estat')){
                $estat = $this->request->getPost('estat');
            }else{
                $estat = NULL;
            }

            $data = [
                'nom_seccio' => $nom,
                'desc_seccio' => $desc,
                'preu_seccio' => $preu,
                'manteniment_seccio' => $manteniment,
                'pagines_seccio' => $pagines,
                'comentaris_seccio' => $comentaris,
                'icon_seccio' => $icona,
                'status_seccio' => $estat
            ];

            $db =  db_connect();
            $builder = $db->table('seccions');
            if($builder->insert($data)){
                $session->setFlashdata('success', 'Nova Secció creada correctament');
                return redirect()->to(base_url().'/seccions/seccio/'.$db->insertID());
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return redirect()->to(base_url().'/seccions');
            }

        }else{
            return redirect()->to(base_url().'/seccions');
        }
    }

    public function editar_seccio($id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $data=[
            'heading' =>'Secció',
        ];
        $session = session();
        if($_POST)
        {
            $nom = $this->request->getPost('nom');
            //$icona = $this->request->getPost('icona');
            $preu = $this->request->getPost('preu-seccio');
            $desc = $this->request->getPost('desc-seccio');
            if($this->request->getPost('pagines')){
                $pagines = $this->request->getPost('pagines');
            }else{
                $pagines = NULL;
            }
            if($this->request->getPost('comentaris')){
                $comentaris = $this->request->getPost('comentaris');
            }else{
                $comentaris = NULL;
            }
            if($this->request->getPost('manteniment')){
                $manteniment = $this->request->getPost('manteniment');
            }else{
                $manteniment = NULL;
            }
            if($this->request->getPost('estat-seccio')){
                $estat = $this->request->getPost('estat-seccio');
            }else{
                $estat = NULL;
            }

            $data = [
                'nom_seccio' => $nom,
                'desc_seccio' => $desc,
                'preu_seccio' => $preu,
                'manteniment_seccio' => $manteniment,
                'pagines_seccio' => $pagines,
                'comentaris_seccio' => $comentaris,
                //'icon_seccio' => $icona,
                'status_seccio' => $estat
            ];

            $db =  db_connect();
            $builder = $db->table('seccions');
            $builder->where('id_seccio', $id);
            if($builder->update($data)){
                $session->setFlashdata('success', 'Secció actualitzada correctament');
                return redirect()->to(base_url().'/seccions/seccio/'.$id);
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return redirect()->to(base_url().'/seccions/seccio/'.$id);
            }

        }else{
            return redirect()->to(base_url().'/seccions/seccio/'.$id);
        }
    }

    /**
     * Opcions
    */
    public function opcio($idSeccio, $id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $data=[
            'heading' =>'Opció',
        ];
        $make_bread = new Make_bread;
        $make_bread->add('Seccions', 'seccions', TRUE);
        $make_bread->add('Secció', 'seccio/'.$idSeccio, TRUE);
        $breadcrumb = $make_bread->output();
        $data['breadcrumb'] =$breadcrumb;
        helper('functions_helper');
        $db = db_connect();
        $seccions = new SeccionsModel($db);
        $data['opcio'] = $seccions->getOpcio($id);
        $data['mods'] = $seccions->getModsOpcio($id);
		return view('admin/app/opcio', $data);
    }

    public function nova_opcio($id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $session = session();
        if($_POST)
        {
            $nom = $this->request->getPost('nom');
            if($this->request->getPost('preu')){
                $preu = $this->request->getPost('preu');
            }else{
                $preu = 0;
            }
            $desc = $this->request->getPost('desc');
            /*if($this->request->getPost('desc-resum')){
                $descResum = $this->request->getPost('desc-resum');
            }else{
                $descResum = NULL;
            }*/
            if($this->request->getPost('tipus')){
                $tipus = $this->request->getPost('tipus');
            }else{
                $tipus = NULL;
            }
            if($this->request->getPost('comentaris')){
                $comentaris = $this->request->getPost('comentaris');
            }else{
                $comentaris = NULL;
            }
            if($this->request->getPost('hores')){
                $hores = $this->request->getPost('hores');
            }else{
                $hores = NULL;
            }
            if($this->request->getPost('estat')){
                $estat = $this->request->getPost('estat');
            }else{
                $estat = NULL;
            }
            if($this->request->getPost('imatge')){
                $imatge = $this->request->getPost('imatge');
            }else{
                $imatge = NULL;
            }
            if($this->request->getPost('url')){
                $url = $this->request->getPost('url');
            }else{
                $url = NULL;
            }
            if($this->request->getPost('obligatori')){
                $obligatori = $this->request->getPost('obligatori');
            }else{
                $obligatori = NULL;
            }

            $data = [
                'id_seccio_opcio' => $id,
                'nom_opcio' => $nom,
                'preu_opcio' => $preu,
                'tipus_opcio' => $tipus,
                'desc_opcio' => $desc,
                //'desc_resum_opcio' => $descResum,
                'comentaris_opcio' => $comentaris,
                'hores_opcio' => $hores,
                'img_opcio' => $imatge,
                'url_opcio' => $url,
                'required_opcio' => $obligatori,
                'status_opcio' => $estat,
            ];

            $db =  db_connect();
            $builder = $db->table('opcions');
            if($builder->insert($data)){
                $lastId = $db->insertID();
                if($tipus == 2){
                    $dataMod = [
                        'id_opcio_mod' => $lastId,
                        'nom_mod' => 'Rang',
                        'preu_mod' => 0,
                        'desc_mod' => '',
                        'desc_resum_mod' => '',
                        'status_mod' => 1,
                        'min_mod' => 1,
                        'max_mod' => 10
                    ];
                    $builder = $db->table('mods');
                    if($builder->insert($dataMod)){
                        $session->setFlashdata('success', 'Nova Opció creada correctament');
                        return redirect()->to(base_url().'/seccions/opcio/'.$id.'/'.$lastId);
                    }
                }else{
                    $session->setFlashdata('success', 'Nova Opció creada correctament');
                    return redirect()->to(base_url().'/seccions/opcio/'.$id.'/'.$db->insertID());
                }
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return redirect()->to(base_url().'/seccions/seccio/'.$id);
            }

        }else{
            return redirect()->to(base_url().'/seccions');
        }
    }

    public function editar_opcio($id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $session = session();
        if($_POST)
        {
            $idSeccio = $this->request->getPost('idSeccio');
            $nom = $this->request->getPost('nom');
            if($this->request->getPost('preu')){
                $preu = $this->request->getPost('preu');
            }else{
                $preu = 0;
            }
            $desc = $this->request->getPost('desc');
            if($this->request->getPost('desc-resum')){
                $descResum = $this->request->getPost('desc-resum');
            }else{
                $descResum = NULL;
            }
            if($this->request->getPost('tipus')){
                $tipus = $this->request->getPost('tipus');
            }else{
                $tipus = NULL;
            }
            if($this->request->getPost('comentaris')){
                $comentaris = $this->request->getPost('comentaris');
            }else{
                $comentaris = NULL;
            }
            if($this->request->getPost('hores')){
                $hores = $this->request->getPost('hores');
            }else{
                $hores = NULL;
            }
            if($this->request->getPost('estat')){
                $estat = $this->request->getPost('estat');
            }else{
                $estat = NULL;
            }
            if($this->request->getPost('imatge')){
                $imatge = $this->request->getPost('imatge');
            }else{
                $imatge = NULL;
            }
            if($this->request->getPost('url')){
                $url = $this->request->getPost('url');
            }else{
                $url = NULL;
            }
            if($this->request->getPost('obligatori')){
                $obligatori = $this->request->getPost('obligatori');
            }else{
                $obligatori = NULL;
            }

            $data = [
                'nom_opcio' => $nom,
                'preu_opcio' => $preu,
                'tipus_opcio' => $tipus,
                'desc_opcio' => $desc,
                'desc_resum_opcio' => $descResum,
                'comentaris_opcio' => $comentaris,
                'hores_opcio' => $hores,
                'img_opcio' => $imatge,
                'url_opcio' => $url,
                'required_opcio' => $obligatori,
                'status_opcio' => $estat,
            ];

            $db =  db_connect();
            $builder = $db->table('opcions');
            $builder->where('id_opcio', $id);
            if($builder->update($data)){
                $session->setFlashdata('success', 'Opció actualitzada correctament');
                return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
            }

        }else{
            return redirect()->to(base_url().'/seccions');
        }
    }

    /**
     * Mods
     */
    public function nou_apartat($idSeccio, $id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $session = session();
        if($_POST)
        {
            $nom = $this->request->getPost('nom');
            if($this->request->getPost('preu')){
                $preu = $this->request->getPost('preu');
            }else{
                $preu = 0;
            }
            $desc = $this->request->getPost('desc');
            if($this->request->getPost('estat')){
                $estat = $this->request->getPost('estat');
            }else{
                $estat = NULL;
            }
            if($this->request->getPost('url')){
                $url = $this->request->getPost('url');
            }else{
                $url = NULL;
            }
            if($this->request->getPost('resum')){
                $resum = $this->request->getPost('resum');
            }else{
                $resum = NULL;
            }

            if($this->request->getFile('imgMod')){
                if (is_uploaded_file($_FILES['imgMod']['tmp_name'])) {
                    $file = $this->request->getFile('imgMod');
                    $fileSize = 15000; //
                    $ext = ['png','jpg','PNG','JPG','jpeg','JPEG','gif','GIF','webp'];
                    $imageSize = $file->getSize();
                    $fileExt = $file->getExtension();
                    //if( $imageSize > $fileSize || !in_array($fileExt,$ext) ){
                    if(!in_array($fileExt,$ext)){
                        $session->setFlashdata('error', 'Imatge no acceptada ');
                        return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
                    }
                    if($file->isValid() && !$file->hasMoved()){
                        $fileUploadPath = './uploads/mods/';
                        $fileName=$file->getRandomName();
        
                        $file->move($fileUploadPath,$fileName);
                        $databaseFilepath='/uploads/mods/';
                        $fileNamePath = $databaseFilepath.$fileName;

                        $imatge = $fileNamePath;
                    }else{
                        $session->setFlashdata('error', 'Imatge no acceptada ');
                        return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
                    }
                }else{
                    $session->setFlashdata('error', 'Imatge no acceptada ');
                    return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
                }
            }else{
                $imatge = NULL;
            }

            $data = [
                'id_opcio_mod' => $id,
                'nom_mod' => $nom,
                'preu_mod' => $preu,
                'desc_mod' => $desc,
                'desc_resum_mod' => $resum,
                'img_mod' => $imatge,
                'url_mod' => $url,
                'status_mod' => $estat,
                'min_mod' => NULL,
                'min_mod' => NULL,
            ];

            $db =  db_connect();
            $builder = $db->table('mods');
            if($builder->insert($data)){
                $session->setFlashdata('success', 'Nou Apartat creat correctament');
                return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
            }

        }else{
            return redirect()->to(base_url().'/seccions');
        }
    }

    public function editar_apartat($idSeccio, $id)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $session = session();
        if($_POST)
        {
            $idMod = $this->request->getPost('idMod');
            $nom = $this->request->getPost('nom');
            if($this->request->getPost('preu')){
                $preu = $this->request->getPost('preu');
            }else{
                $preu = 0;
            }
            $desc = $this->request->getPost('desc');
            if($this->request->getPost('estat')){
                $estat = $this->request->getPost('estat');
            }else{
                $estat = NULL;
            }
            if($this->request->getPost('url')){
                $url = $this->request->getPost('url');
            }else{
                $url = NULL;
            }
            if($this->request->getPost('resum')){
                $resum = $this->request->getPost('resum');
            }else{
                $resum = NULL;
            }
            if($this->request->getPost('min')){
                $min = $this->request->getPost('min');
            }else{
                $min = NULL;
            }
            if($this->request->getPost('max')){
                $max = $this->request->getPost('max');
            }else{
                $max = NULL;
            }

            if($_FILES['imgMod']['tmp_name']){

                $db = db_connect();
                $seccions = new SeccionsModel($db);
                $img = $seccions->getModImg($idMod);

                /*if($img->img_mod){
                    if(file_exists('.'.$img->img_mod))
                        unlink('.'.$img->img_mod);
                }*/

                if (is_uploaded_file($_FILES['imgMod']['tmp_name'])) {
                    $file = $this->request->getFile('imgMod');
                    $fileSize = 30000; //
                    $ext = ['png','jpg','PNG','JPG','jpeg','JPEG','gif','GIF','webp'];
                    $imageSize = $file->getSize();
                    $fileExt = $file->getExtension();
                    //if( $imageSize > $fileSize || !in_array($fileExt,$ext) ){
                    if(!in_array($fileExt,$ext)){
                        $session->setFlashdata('error', 'Imatge no acceptada 1 ');
                        return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
                    }
                    if($file->isValid() && !$file->hasMoved()){
                        $fileUploadPath = './uploads/mods/';
                        $fileName=$file->getRandomName();
        
                        $file->move($fileUploadPath,$fileName);
                        $databaseFilepath='/uploads/mods/';
                        $fileNamePath = $databaseFilepath.$fileName;

                        $imatge = $fileNamePath;
                    }else{
                        $session->setFlashdata('error', 'Imatge no acceptada 2 ');
                        return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
                    }
                }else{
                    $session->setFlashdata('error', 'Imatge no acceptada 3 ');
                    return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
                }
            }elseif($this->request->getPost('imgModOld')){
                $imatge = $this->request->getPost('imgModOld'); 
            }else{
                $imatge = NULL;
            }

            $data = [
                'id_opcio_mod' => $id,
                'nom_mod' => $nom,
                'preu_mod' => $preu,
                'desc_mod' => $desc,
                'desc_resum_mod' => $resum,
                'img_mod' => $imatge,
                'url_mod' => $url,
                'status_mod' => $estat,
                'min_mod' => $min,
                'max_mod' => $max
            ];

            $db =  db_connect();
            $builder = $db->table('mods');
            $builder->where('id_mod', $idMod);
            if($builder->update($data)){
                $session->setFlashdata('success', 'Nou Apartat actualitzat correctament');
                return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
            }else{
                $session->setFlashdata('error', 'Hi ha hagut un error');
                return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
            }

        }else{
            return redirect()->to(base_url().'/seccions');
        }
    }
    
    public function editar_posicio_apartat($id, $pos)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $session = session();
        
        $data = [
            'position_mod' => $pos
        ];

        $db =  db_connect();
        $builder = $db->table('mods');
        $builder->where('id_mod', $id);
        if($builder->update($data)){
            return 'pos: '.$pos;
        }
    }

    public function eliminar_apartat($idSeccio, $id, $idMod)
    {
        if(!session()->get('isLoggedIn')){
            return  redirect()->to(base_url().'/auth');
        }
        $session = session();

        $db = db_connect();
        $seccions = new SeccionsModel($db);
        $img = $seccions->getModImg($idMod);

        if($img->img_mod){
            unlink('.'.$img->img_mod);
        }

        $builder = $db->table('mods');
        $builder->where('id_mod', $idMod);
        if($builder->delete()){
            $session->setFlashdata('success', 'Apartat eliminat correctament');
            return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
        }else{
            $session->setFlashdata('error', 'Hi ha hagut un error');
            return redirect()->to(base_url().'/seccions/opcio/'.$idSeccio.'/'.$id);
        }
    }

}
