<?php

namespace App\Libraries;
use Dompdf;

class Pdf
{
    function createPDF($html, $filename='', $download=TRUE, $paper='A4', $orientation='landscape'){
        $dompdf = new Dompdf\Dompdf();
        $dompdf->load_html($html);
        $dompdf->set_paper($paper, $orientation);
        $dompdf->render();
        $output = $dompdf->output();
        if(file_put_contents('./pdfs/'.$filename.'.pdf', $output))
            return true;
        /*if($download)
            $dompdf->stream($filename.'.pdf', array('Attachment' => 1));
        else
            $dompdf->stream($filename.'.pdf', array('Attachment' => 0));*/
    }

    function savePDF($zipName, $html, $filename='', $download=TRUE, $paper='A4', $orientation='landscape'){
        $dompdf = new Dompdf\Dompdf();
        $dompdf->load_html($html);
        $dompdf->set_paper($paper, $orientation);
        $dompdf->render();
        $output = $dompdf->output();
        file_put_contents('./uploads/pdfs/'.$filename.'.pdf', $output);
        if($this->crearZip($zipName, './uploads/pdfs/'.$filename.'.pdf', $filename.'.pdf')){
            //eliminamos el pdf
            @unlink('./uploads/pdfs/'.$filename.'.pdf');
            //nombre de la carpeta zip
            //$zipName = 'autoritzacions-'.time().'-'.date('d-m-Y');
            //clonamos la carpeta zip con el nuevo nombre
            //copy('./uploads/pdfs/test.zip', './uploads/pdfs/'.$zipName.'.zip');
        }

    }

    function crearZip($zipName, $file, $name)
    {
        $zip = new ZipArchive;
        if ($zip->open('./uploads/pdfs/'.$zipName.'.zip', ZipArchive::CREATE) === TRUE) {
            $zip->addFile($file, $name);
            $zip->close();
            return true;
        }
    }
}
?>