<?php namespace App\Models;

use CodeIgniter\Database\ConnectionInterface;

class FrontModel
{
    protected $db;

    public  function __construct(ConnectionInterface &$db)
    {
        $this->db =& $db;
    }

    /*
     * Get all rows from table
     */
    function getAll(){
        $builder = $this->db->table('seccions');
        $builder->select('*')->where('status_seccio', 1);
        $query = $builder->get()->getResult();
        return $query;
    }
    /*
    * Get count of rows from table
    */
    function getCount(){
        $query = $this->db->query(" 
         SELECT count(id_seccio) as id FROM seccions
         ")->getResult();
        return $query;
    }
    function getSeccioMultiple($arr){
        $builder = $this->db->table('seccions');
        $builder->select('*');
        $builder->whereIn('id_seccio', $arr);
        $query = $builder->get()->getResult();
        return $query;
    }
    function getSeccio($id){
        $builder = $this->db->table('seccions');
        $builder->select('*')->where('id_seccio', $id);
        $query = $builder->get()->getResult();
        return $query;
    }

    /*
     * Opcions
     */
    function getAllOpcionsMultiple($arr){
        $builder = $this->db->table('opcions');
        $builder->select('*');
        $builder->join('seccions', 'seccions.id_seccio = opcions.id_seccio_opcio', 'left');
        $builder->where('opcions.status_opcio', 1);
        $builder->whereIn('opcions.id_seccio_opcio', $arr);
        $query = $builder->get()->getResult();
        return $query;
    }

    function getAllOpcions($id){
        $builder = $this->db->table('opcions');
        $builder->select('*');
        $builder->join('seccions', 'seccions.id_seccio = opcions.id_seccio_opcio', 'left');
        $builder->where(array('opcions.id_seccio_opcio' => $id, 'opcions.status_opcio' => 1));
        $query = $builder->get()->getResult();
        return $query;
    }

    function getOpcio($id){
        $builder = $this->db->table('opcions');
        $builder->select('*');
        $builder->where('opcions.id_opcio', $id);
        $query = $builder->get()->getRow();
        return $query;
    }

    function getModsOpcio($id){
        $builder = $this->db->table('mods');
        $builder->select('*');
        $builder->where('id_opcio_mod', $id);
        $query = $builder->get()->getResult();
        return $query;
    }

    function getModsResum($id){
        $builder = $this->db->table('mods');
        $builder->select('*');
        $builder->join('opcions', 'opcions.id_opcio = mods.id_opcio_mod', 'left');
        $builder->where(array('mods.id_mod' => $id));
        $query = $builder->get()->getResult();
        return $query;
    }

    /**
     * CLIENTS
     */
    function getAllClients($id){
        $builder = $this->db->table('clients');
        $builder->select('*');
        $builder->where('empresa_id_client', $id);
        $query = $builder->get()->getResult();
        return $query;
    }

    function getClient($id){
        $builder = $this->db->table('clients');
        $builder->select('*');
        $builder->where('id_client', $id);
        $query = $builder->get()->getRow();
        return $query;
    }

    /**
     * JSON
     */
    function getOpcionsJson($id)
    {
        $builder = $this->db->table('mods');
        $builder->select('*');
        $builder->where('id_opcio_mod', $id);
        $query = $builder->get()->getResult();
        return $query;
    }

}