<?php namespace App\Models;

use CodeIgniter\Database\ConnectionInterface;

class PressupostosModel
{
    protected $db;

    public  function __construct(ConnectionInterface &$db)
    {
        $this->db =& $db;
    }

    /*
     * Get all rows from table
     */
    function getAll($id){
        $builder = $this->db->table('pressupostos');
        $builder->join('clients', 'clients.id_client = pressupostos.client_id_pressupost', 'left');
        $builder->where('pressupostos.empresa_id_pressupost', $id);
        $builder->orderBy('pressupostos.id_pressupost', 'DESC');
        $query = $builder->get()->getResult();
        return $query;
    }
    
    function getCount($id){
        $query = $this->db->query(" 
         SELECT count(id_pressupost) as id FROM pressupostos WHERE empresa_id_pressupost = 2
         ")->getResult();
        return $query;
    }

    function getPressupost($id){
        $builder = $this->db->table('pressupostos');
        $builder->join('clients', 'clients.id_client = pressupostos.client_id_pressupost', 'left');
        $builder->select('*')->where('pressupostos.id_pressupost', $id);
        $query = $builder->get()->getRow();
        return $query;
    }

    function getResumPressupost($id){
        $builder = $this->db->table('pressupostos');
        $builder->join('clients', 'clients.id_client = pressupostos.client_id_pressupost', 'left');
        $builder->select('*')->where('pressupostos.id_pressupost', $id);
        $query = $builder->get()->getRow();
        return $query;
    }

    function getItemsPressupost($id){
        $builder = $this->db->table('pressupostos');
        $builder->select('id_pressupost, items_pressupost, preu_pressupost, estimation_pressupost, comentaris_items_pressupost')->where('id_pressupost', $id);
        $query = $builder->get()->getRow();
        return $query;
    }

}