<?php namespace App\Models;

use CodeIgniter\Database\ConnectionInterface;

class SeccionsModel
{
    protected $db;

    public  function __construct(ConnectionInterface &$db)
    {
        $this->db =& $db;
    }

    /*
     * Get all rows from table
     */
    function getAll(){
        return $this->db->table('seccions')->get()->getResult();
    }
    /*
    * Get count of rows from table
    */
    function getCount(){
        $query = $this->db->query(" 
         SELECT count(id_seccio) as id FROM seccions
         ")->getResult();
        return $query;
    }
    function getSeccio($id){
        $builder = $this->db->table('seccions');
        $builder->select('*')->where('id_seccio', $id);
        $query = $builder->get()->getResult();
        return $query;
    }

    /*
     * Opcions
     */
    function getAllOpcions($id){
        $builder = $this->db->table('opcions');
        $builder->select('*');
        $builder->join('seccions', 'seccions.id_seccio = opcions.id_seccio_opcio', 'left');
        $builder->where(array('opcions.id_seccio_opcio' => $id, 'opcions.status_opcio' => 1));
        $query = $builder->get()->getResult();
        return $query;
    }

    function getOpcio($id){
        $builder = $this->db->table('opcions');
        $builder->select('*');
        $builder->where(array('opcions.id_opcio' => $id, 'opcions.status_opcio' => 1));
        $query = $builder->get()->getRow();
        return $query;
    }

    function getModsOpcio($id){
        $builder = $this->db->table('mods');
        $builder->select('*');
        $builder->where('id_opcio_mod', $id);
        $builder->orderBy('position_mod', 'ASC');
        $query = $builder->get()->getResult();
        return $query;
    }

    function getModImg($id){
        $builder = $this->db->table('mods');
        $builder->select('img_mod');
        $builder->where('id_mod', $id);
        $query = $builder->get()->getRow();
        return $query;
    }

    /**
     * JSON
     */
    function getOpcionsJson($id)
    {
        $builder = $this->db->table('mods');
        $builder->select('*');
        $builder->where('id_opcio_mod', $id);
        $query = $builder->get()->getResult();
        return $query;
    }

}