<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <div class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?= $heading?></h1>
                </div><!-- /.col -->
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div><!-- /.col -->
            </div><!-- /.row -->
        </div><!-- /.container-fluid -->
    </div>
    <!-- /.content-header -->

    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-8">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Dades de l'Empresa</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form method="post" action="#">
                                <div class="row">
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="nom">Nom*</label>
                                            <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" value="<?= $empresa[0]->nom_empresa ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="email">Email*</label>
                                            <input type="email" class="form-control" id="email" name="email" placeholder="Email" value="<?= $empresa[0]->email_empresa ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="tel">Telèfon</label>
                                            <input type="text" class="form-control" id="tel" name="tel" placeholder="Telèfon" value="<?= $empresa[0]->tel_empresa ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-3">
                                        <div class="form-group">
                                            <label for="web">Web</label>
                                            <input type="url" class="form-control" id="web" name="web" placeholder="https://" value="<?= $empresa[0]->url_empresa ?>">
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="desc">Descipció</label>
                                    <textarea class="form-control" id="desc-seccio" name="desc" rows="3" placeholder="Descipció"><?= $empresa[0]->desc_empresa ?></textarea>
                                </div>
                                <button type="submit" class="btn btn-success btn-sm">
                                    <i class="fas fa-check"></i> Desar Canvis
                                </button>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                        <!-- /.card -->
                </div>
                <div class="col-4">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Disseny</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form method="post" action="#">
                                <div class="form-group">
                                    <div class="row">
                                        <div class="col-4 color-p-m-w">
                                            <label>Color Primari</label>
                                            <input type="text" class="form-control" name="colorPrimari" placeholder="#00000" value="<?= $empresa[0]->color_p_disseny ?>" data-cp="<?= $empresa[0]->color_p_disseny ?>">
                                            <span class="colorPicker-w">
                                                <input type="color" class="colorPicker" id="colorPrimari" placeholder="#00000" value="<?= $empresa[0]->color_p_disseny ?>" data-cp="<?= $empresa[0]->color_p_disseny ?>">
                                            </span>
                                        </div>
                                        <div class="col-4 color-p-m-w">
                                            <label>Color Secundari</label>
                                            <input type="text" class="form-control" name="colorSecundari" placeholder="#00000" value="<?= $empresa[0]->color_s_disseny ?>" data-cs="<?= $empresa[0]->color_s_disseny ?>">
                                            <span class="colorPicker-w">
                                                <input type="color" class="colorPicker" id="colorSecundari" placeholder="#00000" value="<?= $empresa[0]->color_s_disseny ?>" data-cs="<?= $empresa[0]->color_s_disseny ?>">
                                            </span>
                                        </div>
                                    </div>
                                    <br>
                                    <div class="row">
                                        <div class="col-md-8">
                                            <label>Logo</label>
                                            <div class="input-group mb-3">
                                                <div class="custom-file">
                                                    <input type="file" class="custom-file-input" id="inputLogo">
                                                    <label class="custom-file-label" for="inputLogo">Seleccionar</label>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-4 img-prev">
                                            <img src="<?= base_url().'/uploads/empreses/'.$empresa[0]->logo_disseny ?>" class="img-fluid">
                                        </div>
                                    </div>
                                </div>
                                <input type="hidden" name="logo" value="<?= $empresa[0]->logo_disseny ?>">
                                <button type="submit" class="btn btn-success btn-sm">
                                    <i class="fas fa-check"></i> Desar Canvis
                                </button>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                        <!-- /.card -->
                </div>
            </div>
        </div>
    </section>

<script>
jQuery(document).ready(function($) {
	$('[data-cp]').on('change', function(e){
        $('[data-cp]').val($(this).val());
    });
    $('[data-cs]').on('change', function(e){
        $('[data-cs]').val($(this).val());
    });
});
</script>

<?= $this->endSection() ?>