<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?= $heading?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Empreses</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="seccionsTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Nom</th>
                                            <th>Email</th>
                                            <th>Telèfon</th>
                                            <th>Url</th>
                                            <th>Creat el</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($empreses as $empresa):?>
                                        <tr>
                                            <td>
                                                <?= $empresa->nom_empresa ?>
                                            </td>
                                            <td>
                                                <a href="mailto:<?= $empresa->email_empresa ?>" class="text-primary"><?= $empresa->email_empresa ?></a>
                                            </td>
                                            <td>
                                            <?= ($empresa->tel_empresa)?'<a href="tel:'.$empresa->tel_empresa.'" class="text-primary">'.$empresa->tel_empresa.'</a>':'--'; ?>
                                            </td>
                                            <td>
                                                <a href="<?= $empresa->url_empresa ?>" target="_blank" class="text-primary"><?= $empresa->url_empresa ?></a>
                                            </td>
                                            <td>
                                                <?= $empresa->created_at_empresa ?>
                                            </td>
                                            <td>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Veure Empresa"class="btn btn-xs btn-primary btn-opt"><span class="fas fa-eye"></span></a>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Borrar" class="btn btn-xs btn-danger btn-opt"><span class="fas fa-trash"></span></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                     <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<?= $this->endSection() ?>