<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Opció <b><?= $opcio->nom_opcio ?></b></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!--<div class="float-sm-right">
                        <button type="button" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Afegir Nova Opció
                        </button>
                    </div>-->
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <?php if($opcio->tipus_opcio != 2): ?>
                            <h3 class="card-title">Llistat d'Apartats</h3>
                            <?php if((session('empresa_id_user') == 1)): ?>
                            <div class="card-tools">
                                <button type="button" class="btn bg-gray-dark btn-sm" data-toggle="modal" data-target="#modalOpt">
                                    <i class="fas fa-plus"></i> Nou Apartat
                                </button>
                            </div>
                            <?php endif; ?>
                            <?php else: ?>
                            <h3 class="card-title">Editar Apartat Rang</h3>
                            <?php endif; ?>
                        </div>
                        <div class="card-body">

                            <?php if((session('empresa_id_user') != 1)): ?>
                            <div class="wrap-mod"></div>
                            <?php endif; ?>

                            <?php
                            if(count($mods) <= 3){
                                $cols = 'row-cols-3';
                                $col = 'col';
                            }
                            elseif(count($mods) <= 5){
                                $cols = 'row-cols-'.count($mods);
                                $col = 'col';
                            }else{
                                $cols = '';
                                $col = 'col-3';
                            }
                            ?>

                            <?php if($opcio->tipus_opcio != 2): ?>
                            <div class="row <?= $cols ?> selectors">
                                <?php
                                if($mods):
                                foreach($mods as $mod): ?>
                                <div class="<?= $col ?> opt-box-wrap" id="opt-box-wrap-<?= $mod->id_mod ?>" data-position="<?= $mod->position_mod ?>" data-mod="<?= $mod->id_mod ?>">
                                    <?php if($opcio->img_opcio): ?>
                                        <div class="img-wrap-mod">
                                        <?php if($opcio->url_opcio) echo '<a href="'.$mod->url_mod.'" target="_blank" class="external-link-mod"><span><i class="material-icons">link</i>Exemple</span></a>'; ?>
                                        <img src="<?= ($mod->img_mod)?base_url().$mod->img_mod:base_url().'/dist/img/no-image.png'; ?>" class="img-mod">
                                        </div>
                                    <?php endif; ?>
                                    <div class="info-box info-box-opt <?= ($opcio->img_opcio)?'info-box-opt-img':''; ?>" id="opt-<?= $opcio->id_opcio ?>" data-box="opt-<?= $mod->id_mod ?>">
                                        <span class="info-box-icon dropdown">
                                            <button class="btn btn-light btn-sm dropdown-toggle" type="button" id="dropOpts" data-toggle="dropdown" aria-expanded="false">
                                                <i class="fas fa-cog text-primary icon-box-opt"></i>
                                            </button>
                                            <div class="dropdown-menu" aria-labelledby="dropOpts">
                                            <a class="dropdown-item btn-edit-mod" href="javascript:void(0)" data-id="<?= $mod->id_mod ?>" data-name="<?= $mod->nom_mod ?>" data-desc="<?= $mod->desc_mod ?>" data-resum="<?= $mod->desc_resum_mod ?>" data-price="<?= $mod->preu_mod ?>" data-status="<?= $mod->status_mod ?>" data-img="<?= ($mod->img_mod)?$mod->img_mod:''; ?>" data-url="<?= ($mod->url_mod)?$mod->url_mod:''; ?>">
                                                    <i class="fas fa-pencil-alt"></i> Editar
                                                </a>
                                                <a class="dropdown-item delete" href="<?= base_url().'/seccions/eliminar_apartat/'.$opcio->id_seccio_opcio.'/'.$opcio->id_opcio.'/'.$mod->id_mod ?>">
                                                    <i class="fa fa-trash"></i> Eliminar
                                                </a>
                                            </div>
                                        </span>

                                        <div class="info-box-content">
                                            <span class="info-box-text">
                                                <b class="nom-opt-c"><?= $mod->nom_mod ?></b>
                                                <?php if($mod->desc_mod): ?>
                                                <div class="desc-opt-c">
                                                    <span><?= $mod->desc_mod ?></span>
                                                </div>
                                                <?php endif; ?>
                                            </span>
                                            <span class="info-box-number">
                                                <em class="preu-opt"><?= $mod->preu_mod ?></em> €
                                            </span>
                                        </div>
                                        <!-- /.info-box-content -->
                                        <div class="btns-options">
                                            <button type="button" class="btn-opt text-secondary btn-move" data-drag="#opt-box-wrap-<?= $mod->id_mod ?>">
                                                <i class="fas fa-arrows-alt"></i>
                                            </button>
                                        </div>
                                    </div>
                                </div>
                                <?php endforeach; else: ?>
                                <p>No hi ha apartats.</p>
                                <?php endif; ?>
                            </div>
                            <?php else: ?>
                                <form action="<?= base_url().'/seccions/editar_apartat/'.$opcio->id_seccio_opcio.'/'.$opcio->id_opcio ?>" method="post" enctype="multipart/form-data">
                                    <div class="row">
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="nom-mod-e-r">Nom*</label>
                                                <input type="text" class="form-control" id="nom-mod-e-r" name="nom" placeholder="Nom" value="<?= $mods[0]->nom_mod ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="preu-mod">Preu</label>
                                                <div class="input-group mb-3">
                                                    <input type="number" class="form-control" placeholder="Preu" id="preu-mod-e-r" name="preu" aria-describedby="preu-mod-rang" <?= $mods[0]->preu_mod ?>>
                                                    <div class="input-group-append">
                                                        <span class="input-group-text" id="preu-mod-rang">€</span>
                                                    </div>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                            <div class="form-group">
                                                <label for="min-mod">Mínim*</label>
                                                <input type="number" class="form-control" id="min-mod" name="min" placeholder="Mínim" required value="<?= $mods[0]->min_mod ?>">
                                            </div>
                                        </div>
                                        <div class="col-md-3">
                                        <div class="form-group">
                                                <label for="max-mod">Màxim*</label>
                                                <input type="number" class="form-control" id="max-mod" name="max" placeholder="Màxim" required value="<?= $mods[0]->max_mod ?>">
                                            </div>
                                        </div>
                                    </div>
                                    <div class="range-c range-prev">
                                        <h4>Previsualitzar:</h4>
                                        <div class="row">
                                            <div class="col-10">
                                                <input type="range" class="custom-range custom-range-primary" id="range-c-input" min="<?= $mods[0]->min_mod ?>" max="<?= $mods[0]->max_mod ?>" step="1" value="<?= $mods[0]->min_mod ?>" name="pagines">
                                            </div>
                                            <div class="col-2">
                                                <span>
                                                    <b><span id="range-c-input-val"><?= $mods[0]->min_mod ?></span> <?= $mods[0]->nom_mod ?></b>
                                                </span>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="form-group">
                                        <div class="custom-control custom-switch">
                                        <input type="checkbox" class="custom-control-input" name="estat" id="estat-mod-e" value="1" checked>
                                        <label class="custom-control-label" for="estat-mod-e">Activar</label>
                                        </div>
                                    </div>
                                    <input type="hidden" name="idSeccio" value="<?= $opcio->id_seccio_opcio ?>">
                                    <input type="hidden" name="idMod" id="idMod" value="<?= $mods[0]->id_mod ?>">
                                    <div class="modal-footer">
                                        <button type="submit" class="btn btn-success btn-sm">Actualitzar Apartat</button>
                                    </div>
                                </form>
                            <?php endif; ?>

                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">
                                <i class="fas fa-cog"></i> Configuració General
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form method="post" action="<?= base_url().'/seccions/editar_opcio/'.$opcio->id_opcio ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nom">Nom*</label>
                                            <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" value="<?= $opcio->nom_opcio ?>" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="preu">Preu Afegit</label>
                                            <div class="input-group mb-3">
                                                <input type="number" class="form-control" placeholder="Preu" id="preu" name="preu" aria-describedby="preu-seccio" value="<?= $opcio->preu_opcio ?>" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>>
                                                <div class="input-group-append">
                                                    <span class="input-group-text" id="preu-seccio">€</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="desc-seccio">Descipció</label>
                                    <textarea class="form-control" id="desc-seccio" name="desc" rows="3" placeholder="Descipció" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>><?= $opcio->desc_opcio ?></textarea>
                                </div>
                                <div class="form-group">
                                    <label for="desc-seccio-resum">Descipció Resum</label>
                                    <textarea class="form-control" <?= (session('empresa_id_user') == 1)?'id="desc-seccio-resum"':''; ?> name="desc-resum" rows="3" placeholder="Descipció Resum" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>><?= ($opcio->desc_resum_opcio)?$opcio->desc_resum_opcio:''; ?></textarea>
                                </div>
                                <label>Tipus</label>
                                <div class="row radio-label-normal">
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="custom-control custom-radio">
                                                <input class="custom-control-input input-radio-type" type="radio" name="tipus" id="tipus-u" <?= (!$opcio->tipus_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                                <label for="tipus-u" class="custom-control-label">Opció Única</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="custom-control custom-radio">
                                                <input class="custom-control-input input-radio-type" type="radio" name="tipus" id="tipus-m" <?= ($opcio->tipus_opcio == 1)?'checked':''; ?> value="1" <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                                <label for="tipus-m" class="custom-control-label">Opció Múltiple</label>
                                            </div>
                                        </div>
                                    </div>
                                    <div class="col-sm-4">
                                        <div class="form-group">
                                            <div class="custom-control custom-radio">
                                                <input class="custom-control-input input-radio-type" type="radio" name="tipus" id="tipus-r" <?= ($opcio->tipus_opcio == 2)?'checked':''; ?> value="2" <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                                <label for="tipus-r" class="custom-control-label">Opció Rang</label>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="comentaris" id="comentaris-opcio" value="1" <?= ($opcio->comentaris_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="comentaris-opcio">Comentaris</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="imatge" id="imatge-opcio" value="1" <?= ($opcio->img_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="imatge-opcio">Mostrar Imatge</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="url" id="url-opcio" value="1" <?= ($opcio->url_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="url-opcio">Enllaç extern</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="hores" id="hores-opcio" value="1" <?= ($opcio->hores_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="hores-opcio">Hores</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="obligatori" id="obligatori-opcio" value="1" <?= ($opcio->required_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="obligatori-opcio">Camp Obligatori</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="estat" id="estat-opcio" value="1" <?= ($opcio->status_opcio)?'checked':''; ?> <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="estat-opcio">Activar</label>
                                    </div>
                                </div>
                                <input type="hidden" name="idSeccio" value="<?= $opcio->id_seccio_opcio ?>">
                                <?php if((session('empresa_id_user') == 1)): ?>
                                <button type="submit" class="btn btn-success btn-sm">
                                    <i class="fas fa-check"></i> Desar Canvis
                                </button>
                                <?php endif; ?>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
<!-- page script -->

<!-- Modal -->
<div class="modal fade" id="modalOptEdit" tabindex="-1" aria-labelledby="modalOptEditLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
        <form action="<?= base_url().'/seccions/editar_apartat/'.$opcio->id_seccio_opcio.'/'.$opcio->id_opcio ?>" method="post" enctype="multipart/form-data">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSeccioLabel">Editar Apartat</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="nom-mod">Nom*</label>
                            <input type="text" class="form-control" id="nom-mod" name="nom" placeholder="Nom" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="preu-mod">Preu</label>
                            <div class="input-group mb-3">
                                <input type="number" class="form-control" placeholder="Preu" id="preu-mod-e" name="preu" aria-describedby="preu-seccio">
                                <div class="input-group-append">
                                    <span class="input-group-text" id="preu-seccio">€</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="desc-mod-e">Descipció</label>
                    <textarea class="form-control" id="desc-mod-e" name="desc" rows="3" placeholder="Descipció"></textarea>
                </div>
                <div class="form-group">
                    <label for="resum-mod-e">Resum</label>
                    <textarea class="form-control" id="resum-mod-e" name="resum" rows="3" placeholder="Resum"></textarea>
                </div>
                <?php if($opcio->img_opcio): ?>
                    <label>Imatge</label>
                    <div class="input-group mb-3">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" name="imgMod" id="img-mod-e" aria-describedby="img-mod-e">
                            <label class="custom-file-label" for="img-mod-e">Seleccionar imatge</label>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($opcio->url_opcio): ?>
                    <div class="form-group">
                        <label for="url-mod">Enllaç Extern*</label>
                        <input type="url" class="form-control" id="url-mod" name="url" placeholder="Url">
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="estat" id="estat-mod-e" value="1" checked>
                    <label class="custom-control-label" for="estat-mod-e">Activar</label>
                    </div>
                </div>
            </div>
            <input type="hidden" name="idSeccio" value="<?= $opcio->id_seccio_opcio ?>">
            <input type="hidden" name="idMod" id="idMod" value="">
            <input type="hidden" name="imgModOld" id="imgModOld" value="">
            <div class="modal-footer">
                <button type="submit" class="btn btn-success btn-sm">Actualitzar Apartat</button>
            </div>
        </form>
    </div>
  </div>
</div>

<!-- Modal -->
<div class="modal fade" id="modalOpt" tabindex="-1" aria-labelledby="modalOptLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
    <form action="<?= base_url().'/seccions/nou_apartat/'.$opcio->id_seccio_opcio.'/'.$opcio->id_opcio ?>" method="post" enctype="multipart/form-data">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSeccioLabel">Nou Apartat</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="nom">Nom*</label>
                            <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" required>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="preu">Preu</label>
                            <div class="input-group mb-3">
                                <input type="number" class="form-control" placeholder="Preu" id="preu" name="preu" aria-describedby="preu-seccio">
                                <div class="input-group-append">
                                    <span class="input-group-text" id="preu-seccio">€</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="desc-seccio">Descipció</label>
                    <textarea class="form-control" id="desc-seccio" name="desc" rows="3" placeholder="Descipció"></textarea>
                </div>
                <div class="form-group">
                    <label for="desc-seccio">Resum</label>
                    <textarea class="form-control" id="resum-mod" name="resum" rows="3" placeholder="Resum"></textarea>
                </div>
                <?php if($opcio->img_opcio): ?>
                    <label>Imatge</label>
                    <div class="input-group mb-3">
                        <div class="custom-file">
                            <input type="file" class="custom-file-input" name="imgMod" id="img-mod-n" aria-describedby="img-mod">
                            <label class="custom-file-label" for="img-mod-n">Seleccionar imatge</label>
                        </div>
                    </div>
                <?php endif; ?>
                <?php if($opcio->url_opcio): ?>
                    <div class="form-group">
                        <label for="url">Enllaç Extern*</label>
                        <input type="url" class="form-control" id="url" name="url" placeholder="Url">
                    </div>
                <?php endif; ?>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="estat" id="estat-seccio" value="1" checked>
                    <label class="custom-control-label" for="estat-seccio">Activar</label>
                    </div>
                </div>
            </div>
            <input type="hidden" name="idSeccio" value="<?= $opcio->id_seccio_opcio ?>">
            <div class="modal-footer">
                <button type="submit" class="btn btn-success btn-sm">Crear Apartat</button>
            </div>
        </form>
    </div>
  </div>
</div>

<script>
jQuery(document).ready(function($) {
    $( ".selectors" ).sortable({
        connectWith: ".selectors",
        handle: ".btn-move",
        cancel: ".portlet-toggle",
        placeholder: "portlet-placeholder ui-corner-all",
        stop: function(){
            updatePos()
        }
    });
    $( ".selectors" ).disableSelection();
    function updatePos()
    {
        $('.selectors').find('.opt-box-wrap').each(function(e){
            var id = $(this).data('mod');
            var pos = e;
            $(this).attr('data-position', e);
            var xhttp = new XMLHttpRequest();
            xhttp.onreadystatechange = function() {
                if (this.readyState == 4 && this.status == 200) {
                    console.log(this);
                    if(e == 0)
                        toastr.success('', 'Posició Guardada', {timeOut: 1000})
                }
            };
            xhttp.open("GET", baseUrl+"/seccions/editar_posicio_apartat/"+id+'/'+pos, true);
            xhttp.send();
        });
    }
    $('#desc-seccio-resum').richText({
        bold: true,
        italic: true,
        underline: true,
        heading:true,
        imageUpload: false,
        fileUpload: false,
        tables: false,
        fonts: false,
        video: false,
        youtubeCookies:false,
        preview: false
    });
    setTimeout(() => {
        if($(document).find('.richText-editor').html() == '<div><br></div>' || $(document).find('.richText-editor').html() == '<br>'){
            $(document).find('.richText-editor').html('');
            $(document).find('.richText-initial').val('');
        }
    }, 1000);
    //
    $(document).on('click', '.btn-edit-mod', function(e){
        var id = $(this).data('id'),
        name = $(this).data('name'),
        desc = $(this).data('desc'),
        resum = $(this).data('resum'),
        price = $(this).data('price'),
        status = $(this).data('status');
        img = $(this).data('img');
        url = $(this).data('url');
        
        $('#modalOptEdit').find('#idMod').val(id);
        $('#modalOptEdit').find('#nom-mod').val(name);
        $('#modalOptEdit').find('#preu-mod-e').val(price);
        $('#modalOptEdit').find('#desc-mod-e').val(desc);
        $('#modalOptEdit').find('#resum-mod-e').val(resum);
        $('#modalOptEdit').find('#imgModOld').val(img);
        $('#modalOptEdit').find('#url-mod').val(url);
        if(status){
            $('#modalOptEdit').find('#estat-mod-e').attr('checked', 'checked');
        }

        $('#modalOptEdit').modal();
    });
    //
    $('#range-c-input').on('input', function(e){
        var num = $(this).val();
        $('#range-c-input-val').text(num);
    });
    var oldMin = $('#min-mod').val();
    $('#min-mod').on('keyup', function(e){
        var min = parseInt($(this).val());
        var max = parseInt($('#max-mod').val());
        if(min > max){
            alert('El nombre no pot ser més gran que el Màxims');
            $(this).val(oldMin);
            $('#range-c-input').val(oldMin).attr('min', oldMin);
            $('#range-c-input-val').text(oldMin);
        }else{
            $('#range-c-input').val(min).attr('min', min);
            $('#range-c-input-val').text(min);
        }
    });
    $('#max-mod').on('keyup', function(e){
        $('#range-c-input').attr('max', $(this).val());
    });
    //
    var oldTipus = $('.input-radio-type:checked').val();
    $('.input-radio-type').on('change', function(e){
        var tipo = $(this).val();
        if(oldTipus == 2 || tipo == 2){
            var r = confirm("Segur que vols canviar? Si canvies el tipus d\'opció s\'eliminaran tots apartats");
            if (r == true) {
                oldTipus = $(this).val();
                return true;
            } else {
                return false;
            }
        }
    });
});
</script>

<?= $this->endSection() ?>
