<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Secció <b><?= $seccio[0]->nom_seccio ?></b></h1>
                </div>
                <div class="col-sm-6">
                    <!--<div class="float-sm-right">
                        <button type="button" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Afegir Nova Opció
                        </button>
                    </div>-->
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <b>Llistat d'Opcions</b>
                            </h3>
                            <div class="card-tools">
                                <button type="button" class="btn btn-primary btn-sm btn-new-opt">
                                    <i class="fas fa-plus"></i> Nova Opció
                                </button>
                            </div>
                        </div>
                        <div class="card-body">

                            <div id="nova-opcio-wrap" style="display:none">
                                <div class="card">
                                    <div class="card-header">
                                        <h3 class="card-title">Nova Opció</h3>
                                    </div>
                                    <!-- /.card-header -->
                                    <div class="card-body">
                                        <div class="row">
                                            <div class="col-6">
                                                <div class="form-group">
                                                    <label for="nom-nova-opcio">Nom*</label>
                                                    <input type="text" class="form-control" id="nom-nova-opcio" name="nom-opt[]" placeholder="Nom" required>
                                                </div>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <label>Descipció</label>
                                            <textarea class="form-control" rows="3" placeholder="Descipció"></textarea>
                                        </div>
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="hores-nova-opcio" data-wrap="custom-card-nova-opcio">
                                                <label class="custom-control-label" for="hores-nova-opcio">Hores Totals</label>
                                            </div>
                                        </div>
                                        <div class="form-group">
                                            <div class="custom-control custom-switch">
                                                <input type="checkbox" class="custom-control-input" id="comentaris-nova-opcio" data-wrap="custom-card-nova-opcio">
                                                <label class="custom-control-label" for="comentaris-nova-opcio">Accepta Comentaris</label>
                                            </div>
                                        </div>
                                        <div class="selectors">
                                            <div class="form-group">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input multiple-opt" id="multiple-nova-opcio" data-wrap="custom-card-nova-opcio" data-cb="opt-nova">
                                                    <label class="custom-control-label" for="multiple-nova-opcio">Apartats amb Selector Múltiple</label>
                                                </div>
                                            </div>
                                            <div class="row"></div>
                                            <button type="button" class="btn btn-dark btn-sm">
                                                <i class="fas fa-plus"></i> Nou Apartat
                                            </button>
                                        </div>
                                        <button type="button" class="btn btn-success btn-sm">
                                            <i class="fas fa-check"></i> Afegir Opció
                                        </button>
                                    </div>
                                    <!-- /.card-body -->
                                </div>
                            </div>

                            <div class="opcions-list">
                                <?php
                                foreach($opcions as $opcio): ?>
                                <form action="">
                                    <div class="card collapsed-card" id="custom-card-<?= $opcio->id_opcio ?>">
                                        <div class="card-header">
                                            <h3 class="card-title"><?= $opcio->nom_opcio ?></h3>
                                            <div class="card-tools">
                                                <button type="button" class="btn btn-tool" data-card-widget="collapse">
                                                    <i class="fas fa-plus"></i>
                                                </button>
                                            </div>
                                        </div>
                                        <!-- /.card-header -->
                                        <div class="card-body">
                                            <div class="row">
                                                <div class="col-6">
                                                    <div class="form-group">
                                                        <label for="nom-<?= $opcio->id_opcio ?>">Nom</label>
                                                        <input type="text" class="form-control" id="nom-<?= $opcio->id_opcio ?>" name="nom" placeholder="Nom" value="<?= $opcio->nom_opcio ?>">
                                                    </div>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <label for="desc-<?= $opcio->id_opcio ?>">Descipció</label>
                                                <textarea class="form-control" id="desc-<?= $opcio->id_opcio ?>" rows="3" name="desc" placeholder="Descipció"><?= $opcio->desc_opcio ?></textarea>
                                            </div>
                                            <div class="form-group">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="hores-<?= $opcio->id_opcio ?>" data-wrap="custom-card-<?= $opcio->id_opcio ?>" <?= ($opcio->hores_opcio)?'checked':''; ?>>
                                                    <label class="custom-control-label" for="hores-<?= $opcio->id_opcio ?>">Hores Totals</label>
                                                </div>
                                            </div>
                                            <div class="form-group">
                                                <div class="custom-control custom-switch">
                                                    <input type="checkbox" class="custom-control-input" id="comentaris-<?= $opcio->id_opcio ?>" data-wrap="custom-card-<?= $opcio->id_opcio ?>">
                                                    <label class="custom-control-label" name="comentaris" for="comentaris-<?= $opcio->id_opcio ?>">Accepta Comentaris</label>
                                                </div>
                                            </div>
                                            <div class="selectors">
                                                <div class="form-group">
                                                    <div class="custom-control custom-switch">
                                                        <input type="checkbox" class="custom-control-input multiple-opt" id="multiple-<?= $opcio->id_opcio ?>" data-wrap="custom-card-<?= $opcio->id_opcio ?>" data-cb="opt-<?= $opcio->id_opcio ?>" <?= ($opcio->tipus_opcio)?'checked':''; ?>>
                                                        <label class="custom-control-label" for="multiple-<?= $opcio->id_opcio ?>">Apartats amb Selector Múltiple</label>
                                                    </div>
                                                </div>
                                                <div class="row">
                                                    <?php
                                                    $mods = get_mods($opcio->id_opcio);
                                                    foreach($mods as $mod): ?>
                                                    <div class="col-md-4">
                                                        <div class="info-box info-box-opt" id="opt-<?= $opcio->id_opcio ?>" data-box="opt-<?= $mod->id_mod ?>" data-toggle="modal" data-target="#modalOpt">
                                                            <span class="info-box-icon">
                                                                <i class="fas fa-<?= ($opcio->tipus_opcio)?'check-square':'dot-circle'; ?> text-primary icon-box-opt"></i>
                                                            </span>

                                                            <div class="info-box-content">
                                                                <span class="info-box-text">
                                                                    <b class="nom-opt-c"><?= $mod->nom_mod ?></b>
                                                                    <div class="desc-opt-c">
                                                                    <span><?= $mod->desc_mod ?></span>
                                                                    </div>
                                                                </span>
                                                                <span class="info-box-number">
                                                                    <em class="preu-opt"><?= $mod->preu_mod ?></em> €
                                                                </span>
                                                            </div>
                                                            <!-- /.info-box-content -->
                                                        </div>
                                                    </div>
                                                    <?php endforeach; ?>
                                                </div>
                                                <button type="button" class="btn btn-dark btn-sm">
                                                    <i class="fas fa-plus"></i> Nou Apartat
                                                </button>
                                            </div>
                                            <button type="submit" class="btn btn-success btn-sm">
                                                <i class="fas fa-check"></i> Desar Canvis
                                            </button>
                                        </div>
                                        <!-- /.card-body -->
                                    </div>
                                </form>
                                <?php endforeach; ?>
                                <!-- /.card -->
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header">
                            <h3 class="card-title">
                                <i class="fas fa-cog"></i> Configuració General
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form action="">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nom">Nom*</label>
                                            <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" value="<?= $seccio[0]->nom_seccio ?>">
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nom-opt-1">Preu Afegit</label>
                                            <div class="input-group mb-3">
                                                <input type="number" class="form-control" placeholder="Preu" name="preu-seccio" aria-describedby="preu-seccio" value="<?= $seccio[0]->preu_seccio ?>">
                                                <div class="input-group-append">
                                                    <span class="input-group-text" id="preu-seccio">€</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <!--<div class="form-group">
                                    <label for="desc-seccio">Descipció</label>
                                    <textarea class="form-control" id="desc-seccio" name="desc-seccio" rows="3" placeholder="Descipció"></textarea>
                                </div>-->
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="pagines-seccio" <?= ($seccio[0]->pagines_seccio)?'checked':''; ?>>
                                    <label class="custom-control-label" for="pagines-seccio">Pàgines</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="manteniment-seccio" <?= ($seccio[0]->manteniment_seccio)?'checked':''; ?>>
                                    <label class="custom-control-label" for="manteniment-seccio">manteniment</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="estat-seccio" <?= ($seccio[0]->status_seccio)?'checked':''; ?>>
                                    <label class="custom-control-label" for="estat-seccio">Secció Activa</label>
                                    </div>
                                </div>
                                <button type="submit" class="btn btn-success btn-sm">
                                    <i class="fas fa-check"></i> Desar Canvis
                                </button>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
<!-- page script -->

<!-- Modal -->
<div class="modal fade" id="modalOpt" tabindex="-1" aria-labelledby="modalOptLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
      <div class="modal-header">
        <h5 class="modal-title" id="modalOptLabel"></h5>
        <button type="button" class="close" data-dismiss="modal" aria-label="Close">
          <span aria-hidden="true">&times;</span>
        </button>
      </div>
      <div class="modal-body">
        <div class="row">
            <div class="col-6">
                <div class="form-group">
                    <label for="nom-opt-1">Nom*</label>
                    <input type="text" class="form-control" id="nom-opt-1" name="nom-opt[]" placeholder="Nom" value="Web Corporativa" required>
                </div>
            </div>
            <div class="col-md-6">
                <label for="nom-opt-1">Preu*</label>
                <div class="input-group mb-3">
                    <input type="number" class="form-control" placeholder="Preu" name="preu-opt[]" aria-describedby="preu-opt-1" required>
                    <div class="input-group-append">
                        <span class="input-group-text" id="preu-opt-1">€</span>
                    </div>
                </div>
            </div>
        </div>
        <div class="form-group">
            <label for="desc-opt-1">Descipció</label>
            <textarea class="form-control" id="desc-opt-1" name="desc-opt[]" rows="3" placeholder="Descipció"></textarea>
        </div>
        <div class="form-group">
            <div class="custom-control custom-switch">
            <input type="checkbox" class="custom-control-input" id="status-opt[]" checked>
            <label class="custom-control-label" for="status-opt[]">Actiu</label>
            </div>
        </div>
      </div>
      <div class="modal-footer">
        <button type="button" class="btn btn-danger btn-sm">Eliminar</button>
        <button type="button" class="btn btn-success btn-sm">Desar</button>
      </div>
    </div>
  </div>
</div>

<script>
    $(function () {
        $("#seccionsTable").DataTable({
            "responsive": true,
            "autoWidth": false,
        });
    });
</script>
<?= $this->endSection() ?>