<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Pressupost <b>#<?= $pressupost->num_pressupost ?></b></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <!--<div class="row">
                <div class="col-12">
                    <button type="button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target="#modalSeccio">
                        <span class="fas fa-plus">&nbsp;</span>Nova Secció
                    </button>
                </div>
            </div>-->

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Pressupost</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="row">
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label for="num">Número</label>
                                            <input type="text" class="form-control" id="num" name="num" placeholder="Número" value="#<?= $pressupost->num_pressupost ?>" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <div class="form-group">
                                            <label for="preu">Preu</label>
                                            <input type="text" class="form-control" id="preu" name="preu" placeholder="Preu" value="<?= $pressupost->preu_pressupost ?>€" readonly>
                                        </div>
                                    </div>
                                </div>
                                <div class="col-md-4">
                                    <div class="form-group">
                                        <label>Creat el</label>
                                        <div class="form-control">
                                            <?= $pressupost->data_pressupost ?>
                                        </div>
                                    </div>
                                </div>
                            </div>
                            <div class="form-group">
                                <label for="objectius">Objectius</label>
                                <textarea class="form-control" id="objectius" name="objectius" rows="3" placeholder="Objectius" readonly><?= $pressupost->objectius_pressupost ?></textarea>
                            </div>
                            <a href="<?= base_url().'/pressupostos/editarpressupost/'.$pressupost->id_pressupost ?>" class="btn btn-success btn-sm" target="_blank">Editar Pressupost</a>
                            <?php if(!empty($pressupost->pdf_pressupost)): ?>
                            <a href="<?= base_url().'/pdfs/'.$pressupost->pdf_pressupost.'.pdf'; ?>" class="btn btn-info btn-sm" target="_blank">PDF <i class="fas fa-file-pdf"></i></a>
                            <?php endif; ?>
                            <a href="<?= base_url().'/pressupostos/resumpressupost/'.$pressupost->id_pressupost ?>" class="btn btn-warning btn-sm" target="_blank">Veure Resum <i class="fas fa-external-link-alt"></i></a>
                        </div>
                        <!-- /.card-body -->
                    </div>
                     <!-- /.card -->
                </div>
                <!-- /.col -->
                <div class="col-md-4">
                <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Client</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="form-group">
                                <label>Nom</label>
                                <div class="form-control">
                                    <a href="#" class="text-primary">
                                        <?= $pressupost->nom_client ?>
                                    </a>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Email</label>
                                <div class="form-control">
                                    <a href="mailto:<?= $pressupost->email_client ?>" class="text-primary">
                                        <?= $pressupost->email_client ?>
                                    </a>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Telèfon</label>
                                <div class="form-control">
                                    <a href="tel:<?= $pressupost->tel_client ?>" class="text-primary">
                                        <?= $pressupost->tel_client ?>
                                    </a>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>CIF/NIF</label>
                                <div class="form-control">
                                    <?= $pressupost->cif_client ?>
                                </div>
                            </div>
                            <div class="form-group">
                                <label>Direcció</label>
                                <div class="form-control">
                                    <?= $pressupost->dir_client ?>
                                </div>
                            </div>
                            <a href="#" class="btn btn-info btn-sm">Veure Client</a>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<?= $this->endSection() ?>