<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?= $heading?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Pressupostos</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <div class="table-responsive">
                                <table id="seccionsTable" class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Nº</th>
                                            <th>Client</th>
                                            <th>Preu</th>
                                            <th>Creat el</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($pressupostos as $pressu):?>
                                        <tr>
                                            <td>
                                                #<?= $pressu->num_pressupost ?>
                                            </td>
                                            <td>
                                                <a href="#" class="text-primary"><?= $pressu->nom_client ?></a>
                                            </td>
                                            <td>
                                                <?= $pressu->preu_pressupost ?>
                                            </td>
                                            <td>
                                                <?= $pressu->data_pressupost ?>
                                            </td>
                                            <td>
                                            <a href="<?= base_url().'/pressupostos/pressupost/'.$pressu->id_pressupost ?>" data-toggle="tooltip" data-placement="top" title="Veure Pressupost"class="btn btn-xs btn-primary btn-opt"><span class="fas fa-eye"></span></a>
                                            <!--<a href="#" data-toggle="tooltip" data-placement="top" title="Editar"class="btn btn-xs btn-success btn-opt"><span class="fas fa-pencil-alt"></span></a>-->
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Borrar"class="btn btn-xs btn-danger btn-opt"><span class="fas fa-trash"></span></a>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                     <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->


<?= $this->endSection() ?>