<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1>Secció <b><?= $seccio[0]->nom_seccio ?></b></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div>
                <div class="col-sm-6">
                    <!--<div class="float-sm-right">
                        <button type="button" class="btn btn-primary btn-sm">
                            <i class="fas fa-plus"></i> Afegir Nova Opció
                        </button>
                    </div>-->
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">

            <div class="row">
                <div class="col-md-8">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Llistat d'Opcions</h3>
                            <?php if(session('empresa_id_user') == 1): ?>
                            <div class="card-tools">
                                <button type="button" class="btn bg-gray-dark btn-sm btn-new-opt" data-toggle="modal" data-target="#modalOpcio">
                                    <i class="fas fa-plus"></i> Nova Opció
                                </button>
                            </div>
                            <?php endif; ?>
                        </div>
                        <div class="card-body p-0">

                            <div class="opcions-list">

                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                        <th style="width: 10px">#</th>
                                        <th>Nom</th>
                                        <th>Tipus</th>
                                        <th>Estat</th>
                                        <th>Crat el</th>
                                        <th>Accions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach($opcions as $opcio): ?>
                                        <tr>
                                            <td><?= $opcio->id_opcio ?></td>
                                            <td><?= $opcio->nom_opcio ?></td>
                                            <td>
                                                <?php
                                                $tipus = 'dot-circle';
                                                $title = 'Opció Única';
                                                if($opcio->tipus_opcio == 1){
                                                    $tipus = 'check-square';
                                                    $title = 'Opció Múltiple';
                                                }elseif($opcio->tipus_opcio == 2){
                                                    $tipus = 'sliders-h';
                                                    $title = 'Opció Rang';
                                                }
                                                ?>
                                                <i class="fas fa-<?= $tipus ?> text-primary" title="<?= $title ?>"></i>
                                            </td>
                                            <td>
                                                <?= ($opcio->status_opcio)?'<i class="fas fa-check text-lime"></i>':'<i class="far fa-circle text-orange"></i>'; ?>
                                            </td>
                                            <td><?= $opcio->created_at_opcio ?></td>
                                            <td>
                                                <a href="<?= base_url().'/seccions/opcio/'.$seccio[0]->id_seccio.'/'.$opcio->id_opcio ?>" data-toggle="tooltip" data-placement="top" title="Veure Opcions"class="btn btn-xs btn-primary btn-opt"><span class="fas fa-eye"></span></a>
                                                <?php if(session('empresa_id_user') == 1): ?>
                                                <a href="#" data-toggle="tooltip" data-placement="top" title="Borrar"class="btn btn-xs btn-danger btn-opt"><span class="fas fa-trash"></span></a>
                                                <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                                <!-- /.card -->
                            </div>

                        </div>
                    </div>
                </div>
                <div class="col-md-4">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">
                                <i class="fas fa-cog"></i> Configuració General
                            </h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <form method="post" action="<?= base_url().'/seccions/editar_seccio/'.$seccio[0]->id_seccio ?>">
                                <div class="row">
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nom">Nom*</label>
                                            <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom" value="<?= $seccio[0]->nom_seccio ?>" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>>
                                        </div>
                                    </div>
                                    <div class="col-md-6">
                                        <div class="form-group">
                                            <label for="nom-opt-1">Preu Afegit</label>
                                            <div class="input-group mb-3">
                                                <input type="number" class="form-control" placeholder="Preu" name="preu-seccio" aria-describedby="preu-seccio" value="<?= $seccio[0]->preu_seccio ?>" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>>
                                                <div class="input-group-append">
                                                    <span class="input-group-text" id="preu-seccio">€</span>
                                                </div>
                                            </div>
                                        </div>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <label for="desc-seccio">Descipció</label>
                                    <textarea class="form-control" id="desc-seccio" name="desc-seccio" rows="3" placeholder="Descipció" <?= (session('empresa_id_user') != 1)?'readonly':''; ?>><?= $seccio[0]->desc_seccio ?></textarea>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="pagines-seccio" name="pagines" <?= ($seccio[0]->pagines_seccio)?'checked':''; ?> value="1" <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="pagines-seccio">Pàgines</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" name="comentaris" id="comentaris-seccio" <?= ($seccio[0]->comentaris_seccio)?'checked':''; ?> value="1" <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="comentaris-seccio">Comentaris</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="manteniment-seccio" name="manteniment" <?= ($seccio[0]->manteniment_seccio)?'checked':''; ?> value="1" <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="manteniment-seccio">manteniment</label>
                                    </div>
                                </div>
                                <div class="form-group">
                                    <div class="custom-control custom-switch">
                                    <input type="checkbox" class="custom-control-input" id="estat-seccio" name="estat-seccio" <?= ($seccio[0]->status_seccio)?'checked':''; ?> value="1" <?= (session('empresa_id_user') != 1)?'disabled':''; ?>>
                                    <label class="custom-control-label" for="estat-seccio">Activar</label>
                                    </div>
                                </div>
                                <?php if((session('empresa_id_user') == 1)): ?>
                                <button type="submit" class="btn btn-success btn-sm">
                                    <i class="fas fa-check"></i> Desar Canvis
                                </button>
                                <?php endif; ?>
                            </form>
                        </div>
                        <!-- /.card-body -->
                    </div>
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->
<!-- page script -->

<!-- Modal -->
<div class="modal fade" id="modalOpcio" tabindex="-1" aria-labelledby="modalOpcioLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
        <form action="<?= base_url().'/seccions/nova_opcio/'.$seccio[0]->id_seccio ?>" method="post">
            <div class="modal-header">
                <h5 class="modal-title" id="modalOpcioLabel">Nova Opció de <b><?= $seccio[0]->nom_seccio ?></b></h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="nom">Nom*</label>
                            <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom">
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="preu">Preu Afegit</label>
                            <div class="input-group mb-3">
                                <input type="number" class="form-control" placeholder="Preu" id="preu" name="preu" aria-describedby="preu-seccio">
                                <div class="input-group-append">
                                    <span class="input-group-text" id="preu-seccio">€</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="desc-seccio">Descipció</label>
                    <textarea class="form-control" id="desc-seccio" name="desc" rows="3" placeholder="Descipció"><?= $seccio[0]->desc_seccio ?></textarea>
                </div>
                <!--<div class="form-group">
                    <label for="desc-seccio-resum">Descipció Resum</label>
                    <textarea class="form-control" id="desc-seccio-resum" name="desc" rows="3" placeholder="Descipció Resum"></textarea>
                </div>-->
                <label>Tipus</label>
                <div class="row radio-label-normal">
                    <div class="col-sm-3">
                        <div class="form-group">
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" name="tipus" id="tipus-u" checked>
                                <label for="tipus-u" class="custom-control-label">Opció Única</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" name="tipus" id="tipus-m" value="1">
                                <label for="tipus-m" class="custom-control-label">Opció Múltiple</label>
                            </div>
                        </div>
                    </div>
                    <div class="col-sm-4">
                        <div class="form-group">
                            <div class="custom-control custom-radio">
                                <input class="custom-control-input" type="radio" name="tipus" id="tipus-r" value="2">
                                <label for="tipus-r" class="custom-control-label">Opció Rang</label>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="comentaris" id="comentaris-opcio" value="1">
                    <label class="custom-control-label" for="comentaris-opcio">Comentaris</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="imatge" id="imatge-opcio" value="1">
                    <label class="custom-control-label" for="imatge-opcio">Mostrar Imatge</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="url" id="url-opcio" value="1">
                    <label class="custom-control-label" for="url-opcio">Enllaç extern</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="hores" id="hores-opcio" value="1">
                    <label class="custom-control-label" for="hores-opcio">Hores</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="obligatori" id="obligatori-opcio" value="1">
                    <label class="custom-control-label" for="obligatori-opcio">Camp Obligatori</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="estat" id="estat-opcio" value="1" checked>
                    <label class="custom-control-label" for="estat-opcio">Activar</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success btn-sm">Afegir Opció</button>
            </div>
        </form>
    </div>
  </div>
</div>

<script>
    $(function () {
        $("#seccionsTable").DataTable({
            "responsive": true,
            "autoWidth": false,
        });
    });
</script>
<?= $this->endSection() ?>