<?= $this->extend('admin/layouts/main') ?>

<?= $this->section('content') ?>
    <!-- Content Header (Page header) -->
    <section class="content-header">
        <div class="container-fluid">
            <div class="row mb-2">
                <div class="col-sm-6">
                    <h1><?= $heading?></h1>
                </div>
                <div class="col-sm-6">
                    <ol class="breadcrumb float-sm-right">
                        <?= $breadcrumb ?>
                    </ol>
                </div>
            </div>
        </div><!-- /.container-fluid -->
    </section>
    <!-- Main content -->
    <section class="content">
        <div class="container-fluid">
            
            <?php if(isset($_SESSION['error'])): ?>
            <div class="alert alert-danger alert-dismissible fade show" role="alert">
                <strong>Error</strong> <?= $_SESSION['error'] ?>
                <button type="button" class="close" data-dismiss="alert" aria-label="Close">
                    <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <?php endif; ?>

            <?php if(session('empresa_id_user') == 1): ?>
            <div class="row">
                <div class="col-12">
                    <button type="button" class="btn btn-primary mb-2 float-right" data-toggle="modal" data-target="#modalSeccio">
                        <span class="fas fa-plus">&nbsp;</span>Nova Secció
                    </button>
                </div>
            </div>
            <?php endif; ?>
            <div class="row">
                <div class="col-12">
                    <div class="card">
                        <div class="card-header bg-primary">
                            <h3 class="card-title">Seccions</h3>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body p-0">
                            <div class="table-responsive">
                                <table class="table table-striped">
                                    <thead>
                                        <tr>
                                            <th>Actiu</th>
                                            <th>Nom</th>
                                            <th>Icona</th>
                                            <th>Creat el</th>
                                            <th>Actions</th>
                                        </tr>
                                    </thead>
                                    <tbody>
                                        <?php foreach ($seccions as $seccio):?>
                                        <tr>
                                            <td>
                                            <?= ($seccio->status_seccio)?'<i class="fas fa-check text-lime"></i>':'<i class="far fa-circle text-orange"></i>'; ?>
                                            </td>
                                            <td>
                                                <?= $seccio->nom_seccio ?>
                                            </td>
                                            <td>
                                                <span class="material-icons"><?= $seccio->icon_seccio ?></span>
                                            </td>
                                            <td>
                                            <?= $seccio->created_at_seccio ?>
                                            </td>
                                            <td>
                                            <a href="<?= base_url().'/seccions/seccio/'.$seccio->id_seccio ?>" data-toggle="tooltip" data-placement="top" title="Veure Opcions"class="btn btn-xs btn-primary btn-opt"><span class="fas fa-eye"></span></a>
                                            <!--<a href="#" data-toggle="tooltip" data-placement="top" title="Editar"class="btn btn-xs btn-success btn-opt"><span class="fas fa-pencil-alt"></span></a>-->
                                            <?php if(session('empresa_id_user') == 1): ?>
                                            <a href="#" data-toggle="tooltip" data-placement="top" title="Borrar"class="btn btn-xs btn-danger btn-opt"><span class="fas fa-trash"></span></a>
                                            <?php endif; ?>
                                            </td>
                                        </tr>
                                        <?php endforeach; ?>
                                    </tbody>
                                </table>
                            </div>
                        </div>
                        <!-- /.card-body -->
                    </div>
                     <!-- /.card -->
                </div>
                <!-- /.col -->
            </div>
            <!-- /.row -->
        </div>
        <!-- /.container-fluid -->
    </section>
    <!-- /.content -->

<!-- Modal -->
<div class="modal fade" id="modalSeccio" tabindex="-1" aria-labelledby="modalSeccioLabel" aria-hidden="true">
  <div class="modal-dialog">
    <div class="modal-content">
        <form action="<?= base_url().'/seccions/nova_seccio' ?>" method="post">
            <div class="modal-header">
                <h5 class="modal-title" id="modalSeccioLabel">Nova Secció</h5>
                <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                <span aria-hidden="true">&times;</span>
                </button>
            </div>
            <div class="modal-body">
                <div class="form-group">
                    <label for="nom">Nom*</label>
                    <input type="text" class="form-control" id="nom" name="nom" placeholder="Nom">
                    <div class="slug-section">
                        <small>
                            Url: <span id="slug-txt">...</span>
                        </small>
                    </div>
                </div>
                <div class="row">
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="icona">Icona <a href="https://fonts.google.com/icons"target="_blank" title="Google icons"><i class="fas fa-info-circle text-primary"></i></a></label>
                            <div class="input-group mb-3">
                                <input type="text" class="form-control icona-seccio" placeholder="icona" id="icona" name="icona" aria-describedby="icona-seccio" data-icon="#icon-seccio">
                                <div class="input-group-append">
                                    <span class="input-group-text">
                                        <span id="icon-seccio" class="material-icons">favorite_border</span>
                                    </span>
                                </div>
                            </div>
                        </div>
                    </div>
                    <div class="col-md-6">
                        <div class="form-group">
                            <label for="preu">Preu Afegit</label>
                            <div class="input-group mb-3">
                                <input type="number" class="form-control" placeholder="Preu" id="preu" name="preu" aria-describedby="preu-seccio">
                                <div class="input-group-append">
                                    <span class="input-group-text" id="preu-seccio">€</span>
                                </div>
                            </div>
                        </div>
                    </div>
                </div>
                <div class="form-group">
                    <label for="desc-seccio">Descipció</label>
                    <textarea class="form-control" id="desc-seccio" name="desc" rows="3" placeholder="Descipció"></textarea>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="pagines" id="pagines-seccio" value="1">
                    <label class="custom-control-label" for="pagines-seccio">Pàgines</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="comentaris" id="comentaris-seccio" value="1">
                    <label class="custom-control-label" for="comentaris-seccio">Comentaris</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="manteniment" id="manteniment-seccio" value="1">
                    <label class="custom-control-label" for="manteniment-seccio">manteniment</label>
                    </div>
                </div>
                <div class="form-group">
                    <div class="custom-control custom-switch">
                    <input type="checkbox" class="custom-control-input" name="estat" id="estat-seccio" value="1" checked>
                    <label class="custom-control-label" for="estat-seccio">Activar</label>
                    </div>
                </div>
            </div>
            <div class="modal-footer">
                <button type="submit" class="btn btn-success btn-sm">Crear Secció</button>
            </div>
        </form>
    </div>
  </div>
</div>

<script>
/*$(function () {
    $("#seccionsTable").DataTable({
        "responsive": true,
        "autoWidth": false,
    });
});*/
jQuery(document).ready(function($) {
    $('#nom').on('keyup', function(e){
        var slug = string_to_slug($(this).val());
        $('#slug-txt').text(slug);
    });
	$('.icona-seccio').on('input', function(e){
        var icon = $(this).val();
        var iconW = $(this).data('icon');
        $(iconW).text(icon);
    });
});

function string_to_slug (str) {
    str = str.replace(/^\s+|\s+$/g, ''); // trim
    str = str.toLowerCase();
  
    // remove accents, swap ñ for n, etc
    var from = "àáäâèéëêìíïîòóöôùúüûñç·/_,:;";
    var to   = "aaaaeeeeiiiioooouuuunc------";
    for (var i=0, l=from.length ; i<l ; i++) {
        str = str.replace(new RegExp(from.charAt(i), 'g'), to.charAt(i));
    }

    str = str.replace(/[^a-z0-9 -]/g, '') // remove invalid chars
        .replace(/\s+/g, '-') // collapse whitespace and replace by -
        .replace(/-+/g, '-'); // collapse dashes

    return str;
}

</script>

<?= $this->endSection() ?>