<?= $this->extend('layouts/main') ?>

<?= $this->section('content') ?>

    <div id="home">
        <div class="container pt-5 pb-5 text-center container-box-c">
            <div class="project-info-section">
                <form id="formHome" action="<?= base_url() ?>/home/seccio" method="post" enctype="multipart/form-data">
                    <div class="section-option container-medium">
                        <h2 class="title-cost">Dades del Client</h2>
                        <p class="subtitle-cost">
                            Introdueix les dades del client
                        </p>
                        <?php if(isset($empresa[0])): ?>
                        <div id="selectClient">
                            <select id="selectClientOpts" class="form-select">
                                <option value="0" selected>Nou Client</option>
                                <?php foreach($clients as $client): ?>
                                <option value="<?= $client->id_client ?>"><?= $client->nom_client ?></option>
                                <?php endforeach; ?>
                            </select>
                            <input type="hidden" name="clientId" id="clientId" value="">
                        </div>
                        <br>
                        <?php endif; ?>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="input-group mb-3">
                                    <span class="input-group-text" id="nom-client">
                                        <span class="material-icons">person</span>
                                    </span>
                                    <input id="clientNom" type="text" class="form-control clientInput" placeholder="Nom Client/Empresa*" aria-label="Username" aria-describedby="nom-client" name="nom" required value="<?= session("nomClient") ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-group mb-3">
                                    <span class="input-group-text" id="email-client">
                                        @
                                    </span>
                                    <input id="clientEmail" type="email" class="form-control clientInput" placeholder="Email*" aria-describedby="email-client" name="email" required value="<?= session("emailClient") ?>">
                                </div>
                            </div>
                        </div>
                        <div class="row">
                            <div class="col-md-6">
                                <div class="input-group mb-3">
                                    <span class="input-group-text" id="tel-client">
                                        <span class="material-icons">phone</span>
                                    </span>
                                    <input id="clientTel" type="text" class="form-control clientInput" placeholder="Telèfon" aria-describedby="tel-client" name="tel" required value="<?= session("telClient") ?>">
                                </div>
                            </div>
                            <div class="col-md-6">
                                <div class="input-group mb-3">
                                    <span class="input-group-text" id="cif-client">
                                    <span class="material-icons">business</span>
                                    </span>
                                    <input id="clientCif" type="text" class="form-control clientInput" placeholder="Nif/Cif" aria-describedby="cif-client" name="cif" required value="<?= session("cifClient") ?>">
                                </div>
                            </div>
                        </div>
                        <div class="input-group mb-3">
                            <span class="input-group-text" id="dir-client">
                                <span class="material-icons">location_on</span>
                            </span>
                            <input id="clientDir" type="text" class="form-control clientInput" placeholder="Direcció" aria-describedby="dir-client" name="dir" required value="<?= session("dirClient") ?>">
                        </div>
                        <div class="mb-3">
                            <label class="filelabel">
                                <img id="logoPrev" src="<?= base_url() ?>/dist/img/no-image.png" width="100">
                                <span class="title">
                                    Logo
                                </span>
                                <input class="FileUpload1" id="FileInput" name="logo" type="file" accept="image/*">
                                <div class="currentLogo"></div>
                            </label>
                        </div>
                    </div>
                    <div class="section-option container-medium">
                        <h2 class="title-cost">Objectius del Projecte</h2>
                        <p class="subtitle-cost">
                            Descriu breument quins son els objectius
                        </p>
                        <div class="form-floating">
                            <textarea class="form-control textarea-c" placeholder="Leave a comment here" id="floatingTextarea" style="height: 100px" name="objectius"><?= session("objectiusClient") ?></textarea>
                            <label for="floatingTextarea">Objectius</label>
                        </div>
                    </div>
                    <div class="section-option section-option-last">
                        <h2 class="title-cost">Què Necessites?</h2>
                        <p class="subtitle-cost">
                            Selecciona l'opció adequada pel Projecte
                        </p>
                        <div class="options-c">
                            <div class="options-radio-inline">
                                <div class="row">
                                    <?php foreach($seccions as $seccio): ?>
                                    <div class="col-md-3 col-left-c">
                                        <div class="form-radio-option">
                                            <label class="form-check-label">
                                                <div class="title-option">
                                                    <span class="material-icons"><?= $seccio->icon_seccio ?></span>
                                                    <input class="form-check-input form-check-input-home" type="checkbox" name="web-opt" data-id="<?= $seccio->id_seccio ?>" data-slug="<?= $seccio->slug_seccio ?>" value="<?= $seccio->id_seccio ?>" <?= (session("seccioClient") == $seccio->id_seccio)?'checked':''; ?>>
                                                </div>
                                                <small><?= $seccio->nom_seccio ?></small>
                                            </label>
                                        </div>
                                    </div>
                                    <?php endforeach; ?>
                                </div>
                            </div>
                        </div>
                    </div>
                    <br>
                    <div>
                        <div class="inputs-seccions"></div>
                        <button type="submit" class="btn btn-primary btn-lg btn-step"><span class="material-icons">navigate_next</span> SEGÜENT</button>
                        <!--<a href="javascript:void(0)" id="btn-url-section" class="btn btn-primary btn-lg btn-step"><span class="material-icons">navigate_next</span> SEGÜENT</a>-->
                    </div>
                </form>
            </div>
        </div>
    </div>

<script>
jQuery(document).ready(function($) {
    $('[name="web-opt"]').on('change', function(e){
        var id = $(this).data('id');
        var slug = $(this).data('slug');
        //$('#btn-url-section').attr('href', baseUrl+'/home/seccio/'+id+'/'+slug);
        //$('#formHome').attr('action', baseUrl+'/home/seccio/'+id+'/'+slug);
    });
    $('.form-check-input-home').on('click', function(e){
        var id = $(this).val();
        //$('.form-check-label').removeClass('active-opt');
        if($(this).is(':checked')){
            $('.inputs-seccions').prepend('<input id="input-h-'+id+'" type="hidden" name="seccionsId[]" value="'+id+'">');
            $(this).parent().parent().addClass('active-opt');
        }else{
            $('.inputs-seccions').find('input#input-h-'+id).remove();
            $(this).parent().parent().removeClass('active-opt');
        }
    });
    $('#selectClientOpts').on('change', function(e){
        var id = $(this).val();
        if(id != 0){
            $.ajax({
            url: baseUrl+"/home/getClients",
            method: "POST",
            data: {'id':id},
            success: function (data) {
                var obj = jQuery.parseJSON(data);
                $('#clientId').val(id);
                $('#clientNom').val(obj['nom_client']);
                $('#clientEmail').val(obj['email_client']);
                $('#clientTel').val(obj['tel_client']);
                $('#clientCif').val(obj['cif_client']);
                $('#clientDir').val(obj['dir_client']);
                $('#logoPrev').attr('src', baseUrl+obj['logo_client']);
                $('.currentLogo').html('<input type="hidden" name="logoExist" value="'+obj['logo_client']+'">');
            },
            error(data){
                console.log(data.responseText)
            }
        });
        }else{
            $('#clientId').val('');
            $('.clientInput').val('');
            $('.currentLogo').html('');
            $('#logoPrev').attr('src', baseUrl+'/dist/img/no-image.png');
        }
    });
    //
    $("#FileInput").on('change',function (e) {
        var labelVal = $(".title").text();
        var oldfileName = $(this).val();
        fileName = e.target.value.split( '\\' ).pop();

        const [file] = this.files
        if (file) {
            $('#logoPrev').attr('src', URL.createObjectURL(file));
        }

        if (oldfileName == fileName) {return false;}
        var extension = fileName.split('.').pop();

        if(fileName ){
            if (fileName.length > 10){
                $(".filelabel .title").text(fileName.slice(0,4)+'...'+extension);
            }
            else{
                $(".filelabel .title").text(fileName);
            }
        }
        else{
            $(".filelabel .title").text(labelVal);
        }
    });
});
</script>

<?= $this->endSection() ?>