<!doctype html>
<html lang="es">
<head>
<!-- Required meta tags -->
<meta charset="utf-8">
<meta content='width=device-width, initial-scale=1, maximum-scale=1, user-scalable=no' name='viewport'>
<title>Resum Pressupost</title>
<!-- Bootstrap CSS -->
<link href="<?= base_url() ?>/dist/css/bootstrap.min.css" rel="stylesheet" />
<!-- Material Icons -->
<link href="https://fonts.googleapis.com/icon?family=Material+Icons" rel="stylesheet" />
<link rel="stylesheet" href="https://fonts.googleapis.com/css2?family=Montserrat:ital,wght@0,200;0,300;0,400;0,500;0,600;0,800;0,900;1,200;1,300;1,400;1,500;1,600;1,700;1,800;1,900&family=Roboto:ital,wght@0,400;0,500;1,300;1,400;1,500&display=swap" />
<!-- Main css -->
<?php
if(isset($empresa[0])){
    $colorPrimari = $empresa[0]->color_p_disseny;
    $colorSecundari = $empresa[0]->color_s_disseny;
}else{
    $colorPrimari = '#1dbfb9';
    $colorSecundari = '#d6f3f1';
}
?>
<style>
:root {
  --primary: <?= $colorPrimari ?>;
  --secondary: <?= $colorSecundari ?>;
}
body, html, * {
    font-family: 'Montserrat', sans-serif;
}
body {
    background: url(../img/bg-top-2.png) no-repeat center top;
    background-size: 100%;
    background-color: var(--secondary);
    background-attachment: fixed;
    background-blend-mode: luminosity;
}
h1, h2, h3, h4, h5, h6 {
    color: #2a3c4a;
}
.container-box-c {
    background: #fff;
    padding: 20px;
    border-radius: 20px;
    /*border: 1px solid #b9e9e7;*/
    box-shadow: 0px 0px 20px -7px #bdbdbd;
}
.section-option-total {
    padding-bottom: 40px;
    border-bottom: 5px dashed #f1f1f1;
    padding-top: 30px;
}
.section-option-total-last {
    border: none;
    padding-bottom: 10px !important;
}
.container-medium {
    max-width: 600px;
    margin: 0 auto;
}
.input-medium {
    max-width: 350px;
    margin: 0 auto;
}
.container-large {
    max-width: 900px;
    margin: 0 auto;
}
.result-list-c {
    text-align: left;
}
.title-result-c {
    font-weight: 600;
    font-size: 17px;
    color: #fff;
    background: var(--primary);
    background-color: var(--primary);
    padding: 10px;
    margin-bottom: 0px;
}
.result-c ul.result-li-w {
    margin: 0px;
    padding: 0px;
    list-style-type: none;
}
.result-c ul.result-li-w li.result-li-c {
    padding: 10px;
    border-bottom: 5px dashed #f1f1f1;
    margin-top: 10px;
}
.result-c ul.result-li-w li.result-li-c h5 {
    font-size: 15px;
    color: inherit;
    font-weight: 400;
}
.result-c ul.result-li-w li.result-li-c h5 b {
    font-weight: 700;
}
.result-c ul.result-li-w li.result-li-c p {
    font-size: 14px;
    margin: 11px;
    color: #686868;
}
.result-legal {
    padding: 30px;
    background: var(--secondary);
    border-radius: 12px;
    color: var(--primary);
}
.result-legal ul {
    margin: 0;
    padding: 0;
    text-align: left;
    font-size: 12px;
    font-style: italic;
}
.result-legal ul li {
    margin-bottom: 10px;
}
.acceptance {
    margin: 40px auto  0 auto;
}
.acceptance .form-check-input {
    margin: 0;
    position: relative;
    top: 4px;
}

.desc-resum {
    font-size: 12px;
    margin: 20px;
}
.label-img-mod {
    padding: 0px !important;
    overflow: hidden;
}
.label-img-mod .title-option {
    padding: 15px;
}
.label-img-mod .title-option input.form-check-input {
    top: 18px;
    right: 10px;
}
.label-img-mod small {
    padding: 0px 15px 15px 15px;
}
.img-wrap-mod {
    position: relative;
}
.external-link-mod {
    position: absolute;
    display: block;
    width: 100%;
    height: 100%;
    text-align: center;
    /* line-height: 50%; */
    background: var(--primary)a6;
    color: #fff;
    opacity: 0;
    text-decoration: none;
}
.external-link-mod:hover {
    color: #fff;
    opacity: 1;
}
.external-link-mod span {
    position: relative;
    top: 47%;
}
.external-link-mod span i {
    position: relative;
    top: 7px;
    margin-right: 5px;
}
.img-mod {
    width: 100%;
}
.mod-resum li {
    list-style-type: none;
}

.info-client-resum {
    list-style: none;
    padding: 0;
    margin: 20px 0px 0px 0px;
}
.info-client-resum li {
    margin-top: 10px;
}
#signature {
    width: 300px;
    height:100px;
    border:1px solid var(--primary);
    border-radius:5px;
    background:#fff;
    margin:0 auto;
    cursor: crosshair;
}
.btn-reset {
    display: block;
    border: none;
    background: transparent;
    color: #8d8d8d;
    line-height: 10px;
    margin: 0 auto;
    position: relative;
    top: -33px;
    left: -135px;
}
.btn-reset:hover {
    color: #212529;
}
.btn-reset i {
    font-size: 20px;
}
.separator {
    width: 20px;
    height: 2px;
    background-color: #838383;
    margin: 10px auto;
}
.transfer-opts-w {
    text-align: left;
    border-bottom: 5px dashed #f1f1f1;
    margin-bottom: 10px;
    padding-bottom: 10px;
    color: #000;
}
.transfer-opts-w ul.mod-resum {
    padding: 0;
}
.transfer-opts-w ul.mod-resum .form-switch {
    padding-left: 0px;
}
.section-total .title-total-s {
    margin-bottom: 5px;
    margin-top: 0px;
}
.row-img {
    overflow: auto;
    width: 100%;
}
.img-thumbnail {
    width: 100%;
}
.col-img {
    width: 25%;
    float: left;
}
.col-img-desc {
    width: 75%;
    float: right;
}
.clear-b {
    clear: both;
}
.dades-c-list {
    padding-left: 10px;
    text-align: left;
    margin-bottom: 20px;
}
.dades-c-list .title-total-s {
    margin-bottom: 5px;
    margin-top: 0px;
}
</style>
</head>
<body>

    <div class="wrapper">
        <div id="header">
            <nav class="navbar navbar-light">
                <div class="container" style="text-align:center">
                    <?php
                    $logo = base_url().'/uploads/empreses/'.$empresa[0]->logo_disseny;
                    $logoBase64 = "data:image/png;base64," . base64_encode(file_get_contents($logo));
                    ?>
                    <a class="navbar-brand" href="<?= base_url() ?>/?s=1" style="margin: 0 auto">
                        <img src="<?= $logoBase64 ?>" alt="" width="200" height="auto">
                    </a>
                </div>
            </nav>
        </div>
        <!-- Content Wrapper. Contains page content -->
        <div class="content-wrapper">
                
            <div id="cost-sections">
                <div class="container pt-5 pb-5 container-box-c">
                <form id="form-resum" method="post" action="#" enctype="multipart/form-data">
                        <div class="project-info-section">
                            <div class="section-option-total container-medium" style="text-align:center">
                                <?php
                                if(isset($pressupost->logo_client)):
                                    $logoClient = base_url().$pressupost->logo_client;
                                    $clientLogoBase = "data:image/png;base64," . base64_encode(file_get_contents($logoClient));
                                ?>
                                <img class="logoClientResum" src="<?= $clientLogoBase ?>" width="100">
                                <?php endif; ?>
                                <h2 class="title-cost">Pressupost</h2>
                                <!--<p class="subtitle-cost">
                                    El preu final és:
                                </p>-->
                                <?php
                                $iva = 21;
                                $totalIva = 0;
                                $total = $pressupost->preu_pressupost;
                                $totalIva += ($total * $iva / 100);
                                $superTotal = ($total+$totalIva);
                                ?>
                                <h3 class="title-cost title-total"><?= $pressupost->nom_client ?></h3>
                                <ul class="info-client-resum">
                                    <li>
                                        <b>Nº Pressupost:</b> #<?= $pressupost->num_pressupost ?>
                                    </li>
                                    <li>
                                        <b>Data:</b> <?= $pressupost->data_pressupost ?>
                                    </li>
                                </ul>
                            </div>
                            <div class="section-option-total section-option-total-last container-large">
                                <h3 class="title-cost" style="text-align:center">Resum</h3>
                                <br>
                                <div class="result-list-c">
                                    <h4 class="title-result-c" style="background-color: <?= $colorPrimari ?>">Descripció</h4>
                                    <div class="result-c">
                                        <ul class="result-li-w">
                                            <?php
                                            $get_Img_Src = '/<img[^>]*src=([\'"])(?<src>.+?)\1[^>]*>/i';
                                            $resum = $pressupost->resum_pressupost;
                                            preg_match_all($get_Img_Src, $resum, $result); 
                                            //print_r($result['src'][0]);
                                            foreach($result['src'] as $src){
                                                //echo $src.'<br>';
                                                $base64 = "data:image/png;base64," . base64_encode(file_get_contents($src));
                                                $resum = str_replace($src, $base64, $resum);
                                                //echo $base64.'<br>';
                                            }
                                            ?>
                                            <?= $resum ?>
                                        </ul>
                                    </div>
                                </div>
                            </div>
                            <div class="section-option-total-last container-large transfer-opts-w">
                                <div class="transfer-opts">
                                    <h5>Mètode de Pagament: <b><?= $pressupost->pagament_pressupost ?></b></h5>
                                </div>
                            </div>
                            <div class="section-option-total-last container-large transfer-opts-w section-total">
                                <h6 class="title-total-s" style="color:#838383;"><b>Base:</b> <?= $total ?>€</h6>
                                <h6 class="title-total-s" style="color:#838383;"><b>Total IVA:</b> <?= $totalIva ?>€</h6>
                                <h5 class="title-total-s"><b>Import Total:</b> <?= $superTotal ?>€</h5>
                            </div>
                            <h4 class="title-cost" style="text-align:center">Condicions Generals</h4>
                            <br>
                            <div class="result-legal container-large" style="background-color: <?= $colorSecundari ?>;color: #525252">
                                <ul>
                                    <li>
                                        El present pressupost té una validesa de 30 dies naturals a partir de la data que figura en el mateix.
                                    </li>
                                    <li>
                                        En cas que el projecte quedi aturat durant més de 45 dies per part del client, sense que faciliti el material necessari per a finalitzar el projecte, es procedirà a facturar la part del procediment fins a la data. Si es reprèn el projecte, es realitzarà un nou pressupost corresponent a les noves tasques a realitzar.
                                    </li>
                                    <li>
                                        El material necessari per part del client serà entregat, amb els formats prèviament definits per part de Grafix
                                    </li>
                                    <li>
                                        Qualsevol modificació del material requerit per part de l’empresa, es facturarà a banda del pressupost, en hores de treball.
                                    </li>
                                    <li>
                                        En cas d’una modificació del pressupost original, es realitzarà un nou pressupost o es facturarà en hores de treball depenent de la valoració de la modificació a realitzar.
                                    </li>
                                    <li>
                                        A l’inici del projecte s'emetrà una factura del 60% de l’import del pressupost del projecte, com a provisió de fons dels serveis a realitzar. Una vegada acabat el projecte, es facturarà l’altre 40 % restant.
                                    *en el cas que el projecte inclogui allotjament extern a Grafix, s’enviaran els arxius del projecte un cop abonat el 100% del pressupost del projecte.
                                    </li>
                                    <li>
                                        Grafix no es fa responsable de les possibles incidències dels recursos externs, en el cas que s’utilitzin en el projecte.
                                    </li>
                                    <li>
                                        En el cas de canvis de la normativa legal, posteriors al projecte, Grafix no es farà responsable del manteniment ni actualització dels textos, sempre que no estigui prèviament definit en el pressupost original.
                                    *Es recomanable concertar el servei de manteniment/pack d’hores, per tal de tindre la web constantment actualitzada.
                                    </li>
                                    <li>
                                        Grafix  garanteix la confidencialitat del projecte durant tot el procediment de desenvolupament.
                                    </li>
                                </ul>
                            </div>
                            <br>
                            <div class="section-option-total-last container-large transfer-opts-w dades-client">
                                <h4 class="title-result-c" style="background-color: <?= $colorPrimari ?>">Dades Client</h4>
                                <div class="dades-c-list">
                                    <br>
                                    <h6 class="title-total-s"><b>Nom:</b> <span style="color:#838383;"><?= $pressupost->nom_client ?></span></h6>
                                    <h6 class="title-total-s"><b>Email:</b> <span style="color:#838383;"><?= $pressupost->email_client ?></span></h6>
                                    <h6 class="title-total-s"><b>Telèfon:</b> <span style="color:#838383;"><?= $pressupost->tel_client ?></span></h6>
                                    <h6 class="title-total-s"><b>CIF/NIF:</b> <span style="color:#838383;"><?= $pressupost->cif_client ?></span></h6>
                                </div>
                            </div>
                            <div class="acceptance container-medium">
                                <h3 class="title-cost">Signatura</h3>
                                <div class="signature-result">
                                    <?php
                                    $signatura = base_url().'/uploads/signatures/'.$pressupost->signatura_pressupost;
                                    $signaturaBase64 = "data:image/png;base64," . base64_encode(file_get_contents($signatura));
                                    ?>
                                    <img src="<?= $signaturaBase64 ?>" class="img-fluid" style="width:300px;height:100px;border: 1px solid #1dbfb9;border-radius:5px">
                                </div>
                            </div>
                        </div>
                </form>
                </div>
            </div>

        </div>
    </div>
</body>
</html>