# Contributing to RichText

Thank you for your interest in contributing to RichText! 

I've put together the following guidelines to help you figure out where you can best be helpful to the project.

## Quick start

- [Request a new feature](https://github.com/webfashionist/RichText/issues/new??title=Feature%20request:feature-name&template=feature-request.md)
- [Submit a bug report](https://github.com/webfashionist/RichText/issues/new?template=bug-report.md)

## Table of Contents

1. [Types of contributions](#types-of-contributions)
2. [Ground rules & expectations](#ground-rules--expectations)
3. [How to contribute](#how-to-contribute)

## Types of contributions

Currently, there's no specific documentation or style guide for the code. 
Therefore, it would probably be easier to create [issues](https://github.com/webfashionist/RichText/issues) rather than [pull requests](https://github.com/webfashionist/RichText/pulls).

However, there are still many ways you can contribute to RichText:

1. Suggest new ideas on how to extend the editor: [Request a new feature](https://github.com/webfashionist/RichText/issues/new??title=Feature%20request:feature-name&template=feature-request.md)
2. Suggest any update that would simplify the usage of the editor: [Request a new feature](https://github.com/webfashionist/RichText/issues/new??title=Feature%20request:feature-name&template=feature-request.md)
3. Fix or suggest a fix for issues/bugs that occur: [Submit a bug report](https://github.com/webfashionist/RichText/issues/new?template=bug-report.md)


## Ground rules & expectations

Before we get started, here are a few expectations (and that you should expect from others):

- Be kind and thoughtful in your conversations around this project.
- Before opening a pull request, please ensure that you are working on the latest version of RichText.
- If you open a pull request, please ensure that your contribution works in all current browsers.
- The minified versions of the updated files should as well be kept up-to-date.


## How to contribute

If you'd like to contribute, start by searching through the [issues](https://github.com/webfashionist/RichText/issues) and [pull requests](https://github.com/webfashionist/RichText/pulls) to see whether someone else has raised a similar idea or question.

If you don't see your idea listed, and you think it fits into the goals of this guide, do one of the following:

- If your contribution is **minor**, such as a typo fix, or self-contained, such as writing a translation, open a pull request.
- If your contribution is **major**, such as a new guide, start by opening an issue first. That way, other people can weigh in on the discussion before you do any work.

Have a look at [Quick start](#quick-start) to directly open a new issue.

